/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceCreateEquivalent {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceCreateEquivalent.class);

    public static void main(String[] args) {
        logger.info("Creating Kubernetes client");
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            logger.info("Kubernetes client successfully created");
            Namespace namespace = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("test")).endMetadata()).build();
            namespace = (Namespace)((Resource)client.namespaces().resource((Object)namespace)).create();
            logger.info("Created namespace: {}", (Object)namespace.getMetadata().getName());
        }
        catch (KubernetesClientException exception) {
            logger.error("Problem encountered in Kubernetes Client: {}", (Object)exception.getMessage());
        }
    }
}

