/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.BindingBuilder;
import io.fabric8.kubernetes.api.model.BindingFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;

public class BindingExample {
    public static void main(String[] args) {
        String podName = "binding-example-" + Utils.generateId();
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            String namespace = client.getConfiguration().getNamespace() != null ? client.getConfiguration().getNamespace() : (client.getNamespace() != null ? client.getNamespace() : ((Namespace)((NamespaceList)client.namespaces().list()).getItems().stream().findFirst().orElseThrow(() -> new IllegalStateException("No namespace available"))).getMetadata().getName());
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).resource((Object)((PodBuilder)((PodBuilder)new PodBuilder().withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(podName)).build())).withSpec(((PodSpecBuilder)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecBuilder)new PodSpecBuilder().withSchedulerName("random-scheduler-name-which-does-not-exist")).addNewContainer().withName(podName)).withImage("nginx:latest")).endContainer()).build())).build())).create();
            Node firstNode = (Node)((NodeList)client.nodes().list()).getItems().stream().findFirst().orElseThrow(() -> new IllegalStateException("No nodes available"));
            ((Resource)((NonNamespaceOperation)client.bindings().inNamespace(namespace)).resource((Object)((BindingBuilder)((BindingFluent.TargetNested)((BindingFluent.TargetNested)((BindingFluent.TargetNested)((BindingBuilder)((BindingFluent.MetadataNested)new BindingBuilder().withNewMetadata().withName(podName)).endMetadata()).withNewTarget().withKind(firstNode.getKind())).withApiVersion(firstNode.getApiVersion())).withName(firstNode.getMetadata().getName())).endTarget()).build())).create();
            System.out.printf("Successfully bound Pod %s to Node %s%n", podName, firstNode.getMetadata().getName());
        }
    }
}

