/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitUntilReadyExample {
    private static final Logger logger = LoggerFactory.getLogger(WaitUntilReadyExample.class);

    public static void main(String[] args) throws InterruptedException {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).resource((Object)((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodSpecFluent.InitContainersNested)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("myapp-pod")).withLabels(Collections.singletonMap("app", "myapp-pod"))).endMetadata()).withNewSpec().addNewContainer().withName("myapp-container")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo 'The app is running!'; sleep 10"})).endContainer()).addNewInitContainer().withName("init-myservice")).withImage("busybox:1.28")).withCommand(new String[]{"sh", "-c", "echo 'initializing...'; sleep 5"})).endInitContainer()).endSpec()).build())).create();
            logger.info("Pod created, waiting for it to get ready...");
            client.resource((HasMetadata)pod).inNamespace(namespace).waitUntilReady(10L, TimeUnit.SECONDS);
            logger.info("Pod is ready now");
            LogWatch lw = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).watchLog((OutputStream)System.out);
            logger.info("Watching Pod logs for 10 seconds...");
            TimeUnit.SECONDS.sleep(10L);
            logger.info("Deleting Pod...");
            client.resource((HasMetadata)pod).inNamespace(namespace).delete();
            logger.info("Closing Pod log watch");
            lw.close();
        }
    }
}

