/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.OutputStream;

public class ExecExample {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: podName [namespace]");
            return;
        }
        String podName = args[0];
        String namespace = "default";
        if (args.length > 1) {
            namespace = args[1];
        }
        try (KubernetesClient client = new KubernetesClientBuilder().build();
             ExecWatch watch = ExecExample.newExecWatch(client, namespace, podName);){
            watch.exitCode().join();
        }
    }

    private static ExecWatch newExecWatch(KubernetesClient client, String namespace, String podName) {
        return ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).writingOutput((OutputStream)System.out).writingError((OutputStream)System.err).withTTY().usingListener((ExecListener)new SimpleListener()).exec(new String[]{"sh", "-c", "echo 'Hello world!'"});
    }

    private static class SimpleListener
    implements ExecListener {
        private SimpleListener() {
        }

        public void onOpen() {
            System.out.println("The shell will remain open for 10 seconds.");
        }

        public void onFailure(Throwable t, ExecListener.Response failureResponse) {
            System.err.println("shell barfed");
        }

        public void onClose(int code, String reason) {
            System.out.println("The shell will now close.");
        }
    }
}

