/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples.kubectl.equivalents;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodWatchEquivalent {
    private static final Logger logger = LoggerFactory.getLogger((String)PodWatchEquivalent.class.getSimpleName());

    public static void main(String[] args) {
        String namespace = "default";
        final CountDownLatch isWatchClosed = new CountDownLatch(1);
        try (KubernetesClient k8s = new KubernetesClientBuilder().build();){
            ((NonNamespaceOperation)k8s.pods().inNamespace(namespace)).watch((Watcher)new Watcher<Pod>(){

                public void eventReceived(Watcher.Action action, Pod pod) {
                    logger.info("{} {}", (Object)action.name(), (Object)pod.getMetadata().getName());
                    switch (action) {
                        case ADDED: {
                            logger.info("{} got added", (Object)pod.getMetadata().getName());
                            break;
                        }
                        case DELETED: {
                            logger.info("{} got deleted", (Object)pod.getMetadata().getName());
                            break;
                        }
                        case MODIFIED: {
                            logger.info("{} got modified", (Object)pod.getMetadata().getName());
                            break;
                        }
                        default: {
                            logger.error("Unrecognized event: {}", (Object)action.name());
                        }
                    }
                }

                public void onClose(WatcherException e) {
                    logger.info("Closed");
                    isWatchClosed.countDown();
                }
            });
            isWatchClosed.await();
        }
        catch (InterruptedException interruptedException) {
            logger.warn("Interrupted while waiting for the watch to close: {}", (Object)interruptedException.getMessage());
            Thread.currentThread().interrupt();
        }
    }
}

