/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSharedIndexInformerExample {
    private static final Logger logger = LoggerFactory.getLogger((String)DynamicSharedIndexInformerExample.class.getSimpleName());

    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            SharedInformerFactory informerFactory = client.informers();
            CustomResourceDefinitionContext context = new CustomResourceDefinitionContext.Builder().withGroup("demo.fabric8.io").withVersion("v1").withPlural("dummies").withKind("Dummy").withScope("Namespaced").build();
            SharedIndexInformer informer = informerFactory.sharedIndexInformerForCustomResource((ResourceDefinitionContext)context, 60000L);
            informer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<GenericKubernetesResource>(){

                public void onAdd(GenericKubernetesResource genericKubernetesResource) {
                    logger.info("ADD {}/{}", (Object)genericKubernetesResource.getMetadata().getNamespace(), (Object)genericKubernetesResource.getMetadata().getName());
                }

                public void onUpdate(GenericKubernetesResource genericKubernetesResource, GenericKubernetesResource t1) {
                    logger.info("UPDATE {}/{}", (Object)genericKubernetesResource.getMetadata().getNamespace(), (Object)genericKubernetesResource.getMetadata().getName());
                }

                public void onDelete(GenericKubernetesResource genericKubernetesResource, boolean b) {
                    logger.info("DELETE {}/{}", (Object)genericKubernetesResource.getMetadata().getNamespace(), (Object)genericKubernetesResource.getMetadata().getName());
                }
            });
            informerFactory.addSharedInformerEventListener(e -> logger.error(e.getMessage()));
            informerFactory.startAllRegisteredInformers();
            TimeUnit.MINUTES.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.error("interrupted: {}", (Object)interruptedException.getMessage());
        }
    }
}

