/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecLoopExample {
    public static void main(String[] args) throws InterruptedException {
        if (args.length == 0) {
            System.out.println("Usage: podName [namespace]");
            return;
        }
        String podName = args[0];
        String namespace = "default";
        if (args.length > 1) {
            namespace = args[1];
        }
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(20);
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            for (int i = 0; i < 10; ++i) {
                ExecWatch watch = null;
                CompletableFuture pump = null;
                final CountDownLatch latch = new CountDownLatch(1);
                watch = (ExecWatch)((Execable)((TtyExecErrorable)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).redirectingOutput()).usingListener((Object)new ExecListener(){

                    public void onOpen() {
                        System.out.println("Open");
                    }

                    public void onFailure(Throwable t, ExecListener.Response failureResponse) {
                        latch.countDown();
                    }

                    public void onClose(int code, String reason) {
                        latch.countDown();
                    }
                })).exec((Object[])new String[]{"date"});
                pump = InputStreamPumper.pump((InputStream)watch.getOutput(), (b, o, l) -> System.out.print(new String(b, o, l)), (Executor)executorService);
                executorService.scheduleAtFixedRate(new FutureChecker("Pump " + (i + 1), pump), 0L, 2L, TimeUnit.SECONDS);
                latch.await(5L, TimeUnit.SECONDS);
                watch.close();
                pump.cancel(true);
                System.out.println("i=" + i);
            }
        }
        executorService.shutdown();
        System.out.println("Done.");
    }

    private static class FutureChecker
    implements Runnable {
        private final String name;
        private final Future<?> future;

        private FutureChecker(String name, Future<?> future) {
            this.name = name;
            this.future = future;
        }

        @Override
        public void run() {
            if (!this.future.isDone()) {
                System.out.println("Future:[" + this.name + "] is not done yet");
            }
        }
    }
}

