/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetBuilder;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetFluent;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetSpecFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodDisruptionBudgetExample {
    private static final Logger logger = LoggerFactory.getLogger(PodDisruptionBudgetExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(configBuilder.build());){
            String namespace = "default";
            PodDisruptionBudget podDisruptionBudget = ((PodDisruptionBudgetBuilder)((PodDisruptionBudgetFluent.SpecNested)((PodDisruptionBudgetSpecFluent.SelectorNested)((PodDisruptionBudgetFluent.SpecNested)((PodDisruptionBudgetBuilder)((PodDisruptionBudgetFluent.MetadataNested)new PodDisruptionBudgetBuilder().withNewMetadata().withName("zk-pkb")).endMetadata()).withNewSpec().withMaxUnavailable(new IntOrString("1%"))).withNewSelector().withMatchLabels(Collections.singletonMap("app", "zookeeper"))).endSelector()).endSpec()).build();
            logger.info("Current namespace is {}", (Object)"default");
            ((NonNamespaceOperation)client.policy().podDisruptionBudget().inNamespace("default")).createOrReplace((Object[])new PodDisruptionBudget[]{podDisruptionBudget});
        }
        catch (KubernetesClientException e) {
            logger.error("Could not create resource: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

