/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.settings.PodPreset;
import io.fabric8.kubernetes.api.model.settings.PodPresetBuilder;
import io.fabric8.kubernetes.api.model.settings.PodPresetFluent;
import io.fabric8.kubernetes.api.model.settings.PodPresetSpecFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodPresetExamples {
    private static final Logger logger = LoggerFactory.getLogger(PodPresetExamples.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(configBuilder.build());){
            String namespace = "default";
            logger.info("Namespace: {}", (Object)namespace);
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).load(PodPresetExamples.class.getResourceAsStream("/pod-preset-example.yml"))).get();
            logger.info("Pod created");
            ((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object)pod);
            PodPreset podPreset = ((PodPresetBuilder)((PodPresetFluent.SpecNested)((PodPresetFluent.SpecNested)((PodPresetFluent.SpecNested)((PodPresetFluent.SpecNested)((PodPresetSpecFluent.SelectorNested)((PodPresetBuilder)((PodPresetFluent.MetadataNested)new PodPresetBuilder().withNewMetadata().withName("allow-database")).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(Collections.singletonMap("role", "frontend"))).endSelector()).withEnv(new EnvVar[]{((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("DB_PORT")).withValue("6379")).build()})).withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath("/cache")).withName("cache-volume")).build()})).withVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("cache-volume")).withEmptyDir(new EmptyDirVolumeSourceBuilder().build())).build()})).endSpec()).build();
            logger.info("Creating Pod Preset : {}", (Object)podPreset.getMetadata().getName());
            ((NonNamespaceOperation)client.settings().podPresets().inNamespace(namespace)).create((Object)podPreset);
            pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).get();
            logger.info("Updated pod: ");
            logger.info(SerializationUtils.dumpAsYaml((HasMetadata)pod));
        }
        catch (Exception e) {
            logger.error("Exception occurred: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

