/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.List;
import java.util.Map;

public class LoadMultipleDocumentsFromFileExample {
    public static void main(String[] args) throws InterruptedException {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            List list = (List)client.load(LoadMultipleDocumentsFromFileExample.class.getResourceAsStream("/multiple-document-template.yml")).get();
            System.out.println("Found in file:" + list.size() + " items.");
            for (HasMetadata meta : list) {
                System.out.println(LoadMultipleDocumentsFromFileExample.display(meta));
            }
            list = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.load(LoadMultipleDocumentsFromFileExample.class.getResourceAsStream("/multiple-document-template.yml")).accept(new Visitor[]{new Visitor<ObjectMetaBuilder>(){

                public void visit(ObjectMetaBuilder item) {
                    item.addToLabels("visitorkey", "visitorvalue");
                }
            }})).get();
            System.out.println("Visited:" + list.size() + " items.");
            for (HasMetadata meta : list) {
                System.out.println(LoadMultipleDocumentsFromFileExample.display(meta));
            }
        }
    }

    private static String display(HasMetadata item) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        if (Utils.isNotNullOrEmpty((String)item.getKind())) {
            sb.append(" Kind:").append(item.getKind());
        }
        if (Utils.isNotNullOrEmpty((String)item.getMetadata().getName())) {
            sb.append(" Name:").append(item.getMetadata().getName());
        }
        if (item.getMetadata().getLabels() != null && !item.getMetadata().getLabels().isEmpty()) {
            sb.append(" Lables: [ ");
            for (Map.Entry entry : item.getMetadata().getLabels().entrySet()) {
                sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(" ");
            }
            sb.append("]");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

