/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsList;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopExample {
    private static final Logger logger = LoggerFactory.getLogger(TopExample.class);

    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            NodeMetricsList nodeMetricList = client.top().nodes().metrics();
            logger.info("==== Node Metrics  ====");
            nodeMetricList.getItems().forEach(nodeMetrics -> logger.info("{}\tCPU: {}{}\tMemory: {}{}", new Object[]{nodeMetrics.getMetadata().getName(), ((Quantity)nodeMetrics.getUsage().get("cpu")).getAmount(), ((Quantity)nodeMetrics.getUsage().get("cpu")).getFormat(), ((Quantity)nodeMetrics.getUsage().get("memory")).getAmount(), ((Quantity)nodeMetrics.getUsage().get("memory")).getFormat()}));
            logger.info("==== Pod Metrics ====");
            client.top().pods().metrics("default").getItems().forEach(podMetrics -> podMetrics.getContainers().forEach(containerMetrics -> logger.info("{}\t{}\tCPU: {}{}\tMemory: {}{}", new Object[]{podMetrics.getMetadata().getName(), containerMetrics.getName(), ((Quantity)containerMetrics.getUsage().get("cpu")).getAmount(), ((Quantity)containerMetrics.getUsage().get("cpu")).getFormat(), ((Quantity)containerMetrics.getUsage().get("memory")).getAmount(), ((Quantity)containerMetrics.getUsage().get("memory")).getFormat()})));
            String defaultNamespace = "default";
            ((PodList)((NonNamespaceOperation)client.pods().inNamespace("default")).list()).getItems().stream().findFirst().map(arg_0 -> TopExample.lambda$main$3((KubernetesClient)client, arg_0)).ifPresent(podMetrics -> podMetrics.getContainers().forEach(containerMetrics -> logger.info("{}\t{}\tCPU: {}{}\tMemory: {}{}", new Object[]{podMetrics.getMetadata().getName(), containerMetrics.getName(), ((Quantity)containerMetrics.getUsage().get("cpu")).getAmount(), ((Quantity)containerMetrics.getUsage().get("cpu")).getFormat(), ((Quantity)containerMetrics.getUsage().get("memory")).getAmount(), ((Quantity)containerMetrics.getUsage().get("memory")).getFormat()})));
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ PodMetrics lambda$main$3(KubernetesClient client, Pod pod) {
        logger.info("==== Individual Pod Metrics ({}) ====", (Object)pod.getMetadata().getName());
        return client.top().pods().metrics("default", pod.getMetadata().getName());
    }
}

