/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeleteExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        DefaultKubernetesClient client = new DefaultKubernetesClient(config);
        try {
            DeleteExamples.log("Create namespace:", client.namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).endMetadata()).build()));
            DeleteExamples.log("Deleted namespace:", ((Resource)client.namespaces().withName("test")).delete());
            DeleteExamples.log("Deleted testPod:", ((PodResource)((NonNamespaceOperation)client.pods().inNamespace("thisisatest")).withName("testpod")).delete());
            DeleteExamples.log("Deleted pod by label:", ((FilterWatchListDeletable)client.pods().withLabel("this", "works")).delete());
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ((Resource)client.namespaces().withName("thisisatest")).delete();
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

