/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.NodeSelectorFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.VolumeNodeAffinityFluent;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentVolumeClaimExample {
    private static final Logger logger = LoggerFactory.getLogger(PersistentVolumeClaimExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        PersistentVolumeClaimExample.log("Using master with url ", master);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            try {
                StorageClass storageClass = (StorageClass)((Resource)client.storage().storageClasses().load(PersistentVolumeClaimExample.class.getResourceAsStream("/test-storage.yml"))).get();
                client.storage().storageClasses().create((Object[])new StorageClass[]{storageClass});
                PersistentVolumeClaimExample.log("Creating PersistentVolume object");
                PersistentVolume pv = ((PersistentVolumeBuilder)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.NodeAffinityNested)((VolumeNodeAffinityFluent.RequiredNested)((NodeSelectorFluent.NodeSelectorTermsNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.LocalNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeBuilder)((PersistentVolumeFluent.MetadataNested)new PersistentVolumeBuilder().withNewMetadata().withName("test-local-pv")).endMetadata()).withNewSpec().addToCapacity(Collections.singletonMap("storage", new Quantity("500Gi")))).withAccessModes(new String[]{"ReadWriteOnce"})).withPersistentVolumeReclaimPolicy("Retain")).withStorageClassName("my-local-storage")).withNewLocal().withPath("/mnt/disks/vol1")).endLocal()).withNewNodeAffinity().withNewRequired().addNewNodeSelectorTerm().withMatchExpressions(Arrays.asList(((NodeSelectorRequirementBuilder)((NodeSelectorRequirementBuilder)((NodeSelectorRequirementBuilder)new NodeSelectorRequirementBuilder().withKey("kubernetes.io/hostname")).withOperator("In")).withValues(new String[]{"my-node"})).build()))).endNodeSelectorTerm()).endRequired()).endNodeAffinity()).endSpec()).build();
                client.persistentVolumes().create((Object[])new PersistentVolume[]{pv});
                client.persistentVolumes().create((Object[])new PersistentVolume[]{pv});
                PersistentVolumeClaimExample.log("Successfully created PersistentVolume object");
                PersistentVolumeClaimExample.log("Creating PersistentVolumeClaim object");
                PersistentVolumeClaim persistentVolumeClaim = ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName("test-pv-claim")).endMetadata()).withNewSpec().withStorageClassName("my-local-storage")).withAccessModes(new String[]{"ReadWriteOnce"})).withNewResources().addToRequests("storage", new Quantity("500Gi"))).endResources()).endSpec()).build();
                client.persistentVolumeClaims().create((Object[])new PersistentVolumeClaim[]{persistentVolumeClaim});
                PersistentVolumeClaimExample.log("Successfully created PersistentVolumeClaim object");
                PersistentVolumeClaimExample.log("Creating pod");
                Pod pod = (Pod)((PodResource)client.pods().load(PersistentVolumeClaimExample.class.getResourceAsStream("/test-pv-pod.yml"))).get();
                client.pods().create((Object[])new Pod[]{pod});
                PersistentVolumeClaimExample.log("Successfully created pod");
            }
            finally {
                ((Resource)client.persistentVolumeClaims().withName("test-pv-claim")).delete();
                ((Resource)client.persistentVolumes().withName("test-pv")).delete();
            }
        }
        catch (KubernetesClientException e) {
            PersistentVolumeClaimExample.log("Could not create resource", e.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

