/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicyBuilder;
import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicyFluent;
import io.fabric8.kubernetes.api.model.extensions.PodSecurityPolicySpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PodSecurityPolicyExample {
    private static final Logger logger = Logger.getLogger(PodSecurityPolicyExample.class.getName());

    public static void main(String[] args) throws InterruptedException {
        String sample = System.getProperty("user.dir") + "/kubernetes-examples/src/main/resources/PodSecurityPolicy.yml";
        try {
            DefaultKubernetesClient client = new DefaultKubernetesClient();
            logger.log(Level.INFO, "Loading File : " + sample);
            PodSecurityPolicy podSecurityPolicy = (PodSecurityPolicy)((Resource)client.extensions().podSecurityPolicies().load((InputStream)new FileInputStream(sample))).get();
            client.extensions().podSecurityPolicies().create((Object[])new PodSecurityPolicy[]{podSecurityPolicy});
            logger.log(Level.INFO, "PodSecurityPolicy created with Name : " + podSecurityPolicy.getMetadata().getName());
            logger.log(Level.INFO, "Starting creating PodSecurityPolicy from Builder ");
            PodSecurityPolicy podSecurityPolicy1 = ((PodSecurityPolicyBuilder)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.SupplementalGroupsNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.SeLinuxNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.FsGroupNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicySpecFluent.RunAsUserNested)((PodSecurityPolicyFluent.SpecNested)((PodSecurityPolicyBuilder)((PodSecurityPolicyFluent.MetadataNested)new PodSecurityPolicyBuilder().withNewMetadata().withName("example2")).endMetadata()).withNewSpec().withPrivileged(Boolean.valueOf(false))).withNewRunAsUser().withRule("RunAsAny")).endRunAsUser()).withNewFsGroup().withRule("RunAsAny")).endFsGroup()).withNewSeLinux().withRule("RunAsAny")).endSeLinux()).withNewSupplementalGroups().withRule("RunAsAny")).endSupplementalGroups()).endSpec()).build();
            client.extensions().podSecurityPolicies().create((Object[])new PodSecurityPolicy[]{podSecurityPolicy1});
            logger.log(Level.INFO, "PodSecurityPolicy created with Name : " + podSecurityPolicy1.getMetadata().getName());
            client.close();
        }
        catch (KubernetesClientException ClientException) {
            logger.log(Level.SEVERE, "Problem encountered with Kubernetes client!!");
            ClientException.printStackTrace();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception encountered : " + e.getMessage());
        }
    }
}

