/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.WatchAndWaitable;
import io.fabric8.kubernetes.examples.crds.DoneableDummy;
import io.fabric8.kubernetes.examples.crds.Dummy;
import io.fabric8.kubernetes.examples.crds.DummyList;
import io.fabric8.kubernetes.examples.crds.DummySpec;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDExample {
    private static final Logger logger = LoggerFactory.getLogger(CRDExample.class);
    public static String DUMMY_CRD_GROUP = "demo.fabric8.io";
    public static String DUMMY_CRD_NAME = "dummies." + DUMMY_CRD_GROUP;
    private static boolean logRootPaths = false;

    private static String resourceScope(boolean resourceNamespaced) {
        if (resourceNamespaced) {
            return "Namespaced";
        }
        return "Cluster";
    }

    public static void main(String[] args) {
        boolean resourceNamespaced = true;
        String namespace = null;
        if (args.length > 0) {
            if ("--cluster".equals(args[0])) {
                resourceNamespaced = false;
            } else {
                namespace = args[0];
            }
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            List paths;
            RootPaths rootPaths;
            if (resourceNamespaced) {
                if (namespace == null) {
                    namespace = client.getNamespace();
                }
                if (namespace == null) {
                    System.err.println("No namespace specified and no default defined!");
                    return;
                }
                System.out.println("Using namespace: " + namespace);
            } else {
                System.out.println("Creating cluster scoped resource");
            }
            if (logRootPaths && (rootPaths = client.rootPaths()) != null && (paths = rootPaths.getPaths()) != null) {
                System.out.println("Supported API Paths:");
                for (Object path : paths) {
                    System.out.println("    " + (String)path);
                }
                System.out.println();
            }
            CustomResourceDefinitionList crds = (CustomResourceDefinitionList)client.customResourceDefinitions().list();
            List crdsItems = crds.getItems();
            System.out.println("Found " + crdsItems.size() + " CRD(s)");
            CustomResourceDefinition dummyCRD = null;
            for (CustomResourceDefinition crd : crdsItems) {
                ObjectMeta metadata = crd.getMetadata();
                if (metadata == null) continue;
                String name = metadata.getName();
                System.out.println("    " + (String)name + " => " + metadata.getSelfLink());
                if (!DUMMY_CRD_NAME.equals(name)) continue;
                dummyCRD = crd;
            }
            if (dummyCRD != null) {
                System.out.println("Found CRD: " + dummyCRD.getMetadata().getSelfLink());
            } else {
                dummyCRD = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion("apiextensions.k8s.io/v1beta1")).withNewMetadata().withName(DUMMY_CRD_NAME)).endMetadata()).withNewSpec().withGroup(DUMMY_CRD_GROUP)).withVersion("v1")).withScope(CRDExample.resourceScope(resourceNamespaced))).withNewNames().withKind("Dummy")).withShortNames(new String[]{"dummy"})).withPlural("dummies")).endNames()).endSpec()).build();
                client.customResourceDefinitions().create((Object)dummyCRD);
                System.out.println("Created CRD " + dummyCRD.getMetadata().getName());
            }
            KubernetesDeserializer.registerCustomKind((String)(DUMMY_CRD_GROUP + "/v1"), (String)"Dummy", Dummy.class);
            MixedOperation dummyClient = client.customResources(dummyCRD, Dummy.class, DummyList.class, DoneableDummy.class);
            if (resourceNamespaced) {
                dummyClient = (NonNamespaceOperation)dummyClient.inNamespace(namespace);
            }
            CustomResourceList dummyList = (CustomResourceList)dummyClient.list();
            List items = dummyList.getItems();
            System.out.println("  found " + items.size() + " dummies");
            for (Dummy item : items) {
                System.out.println("    " + (Object)((Object)item));
            }
            Dummy dummy = new Dummy();
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName("foo");
            dummy.setMetadata(metadata);
            DummySpec dummySpec = new DummySpec();
            Date now = new Date();
            dummySpec.setBar("beer: " + now);
            dummySpec.setFoo("cheese: " + now);
            dummy.setSpec(dummySpec);
            Dummy created = (Dummy)((Object)dummyClient.createOrReplace((Object[])new Dummy[]{dummy}));
            System.out.println("Upserted " + (Object)((Object)dummy));
            created.getSpec().setBar("otherBar");
            dummyClient.createOrReplace((Object[])new Dummy[]{created});
            System.out.println("Watching for changes to Dummies");
            ((WatchAndWaitable)dummyClient.withResourceVersion(created.getMetadata().getResourceVersion())).watch((Object)new Watcher<Dummy>(){

                public void eventReceived(Watcher.Action action, Dummy resource) {
                    System.out.println("==> " + action + " for " + (Object)((Object)resource));
                    if (resource.getSpec() == null) {
                        logger.error("No Spec for resource " + (Object)((Object)resource));
                    }
                }

                public void onClose(KubernetesClientException cause) {
                }
            });
            System.in.read();
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

