/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.util.List;

public class ListBuildConfigs {
    public static void main(String[] args) {
        try {
            DefaultOpenShiftClient client = new DefaultOpenShiftClient();
            if (!client.supportsOpenShiftAPIGroup("build.openshift.io")) {
                System.out.println("WARNING this cluster does not support the API Group build.openshift.io");
                return;
            }
            BuildConfigList list = (BuildConfigList)client.buildConfigs().list();
            if (list == null) {
                System.out.println("ERROR no list returned!");
                return;
            }
            List items = list.getItems();
            for (BuildConfig item : items) {
                System.out.println("BuildConfig " + item.getMetadata().getName() + " has version: " + item.getApiVersion());
            }
        }
        catch (KubernetesClientException e) {
            System.out.println("Failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }
}

