/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.MetricSpec;
import io.fabric8.kubernetes.api.model.MetricSpecBuilder;
import io.fabric8.kubernetes.api.model.MetricSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalPodAutoscalerExample {
    private static final Logger logger = LoggerFactory.getLogger(HorizontalPodAutoscalerExample.class);

    public static void main(String[] args) {
        String master = "https://192.168.42.193:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            HorizontalPodAutoscaler horizontalPodAutoscaler = ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested)((HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested)((HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName("the-hpa")).withNamespace("default")).endMetadata()).withNewSpec().withNewScaleTargetRef().withApiVersion("apps/v1")).withKind("Deployment")).withName("the-deployment")).endScaleTargetRef()).withMinReplicas(Integer.valueOf(1))).withMaxReplicas(Integer.valueOf(10))).addToMetrics(new MetricSpec[]{((MetricSpecBuilder)((MetricSpecFluent.ResourceNested)((MetricSpecFluent.ResourceNested)((MetricSpecBuilder)new MetricSpecBuilder().withType("Resource")).withNewResource().withName("cpu")).withTargetAverageUtilization(Integer.valueOf(50))).endResource()).build()})).endSpec()).build();
            ((NonNamespaceOperation)client.autoscaling().horizontalPodAutoscalers().inNamespace("default")).create((Object[])new HorizontalPodAutoscaler[]{horizontalPodAutoscaler});
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

