/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecLoopExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        String master = "https://localhost:8443/";
        String podName = null;
        if (args.length == 2) {
            master = args[0];
            podName = args[1];
        }
        if (args.length == 1) {
            podName = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient(config);){
            for (int i = 0; i < 10; ++i) {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                try (ExecWatch watch = (ExecWatch)((TtyExecErrorable)((PodResource)client.pods().withName(podName)).redirectingOutput()).exec((Object[])new String[]{"date"});
                     InputStreamPumper pump = new InputStreamPumper(watch.getOutput(), (Callback)new SystemOutCallback());){
                    executorService.submit((Runnable)pump);
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
                finally {
                    executorService.shutdown();
                }
                System.out.println("i=" + i);
            }
        }
        System.out.println("Done.");
    }

    private static class SystemOutCallback
    implements Callback<byte[]> {
        private SystemOutCallback() {
        }

        public void call(byte[] data) {
            System.out.print(new String(data));
        }
    }
}

