/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Config config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient(config);
        OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
        try {
            Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).addToLabels("this", "rocks")).endMetadata()).build();
            DeploymentConfigExamples.log("Created namespace", client.namespaces().create((Object[])new Namespace[]{ns}));
            ServiceAccount fabric8 = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("fabric8")).endMetadata()).build();
            ((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace("thisisatest")).create((Object[])new ServiceAccount[]{fabric8});
            DeploymentConfigExamples.log("Created deployment", ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)((DeploymentConfigFluent.MetadataNested)((DoneableDeploymentConfig)((ClientNonNamespaceOperation)client.deploymentConfigs().inNamespace("thisisatest")).createNew()).withNewMetadata().withName("nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).addToSelector("app", "nginx")).withNewTemplate().withNewMetadata().addToLabels("app", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).done());
            ((ClientScaleableResource)((ClientNonNamespaceOperation)client.deploymentConfigs().inNamespace("thisisatest")).withName("nginx")).scale(2, true);
            DeploymentConfigExamples.log("Created pods:", ((PodList)((ClientNonNamespaceOperation)client.pods().inNamespace("thisisatest")).list()).getItems());
            ((ClientScaleableResource)((ClientNonNamespaceOperation)client.deploymentConfigs().inNamespace("thisisatest")).withName("nginx")).scale(0);
            DeploymentConfigExamples.log("Done.");
        }
        finally {
            ((ClientResource)client.namespaces().withName("thisisatest")).delete();
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

