/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchExample {
    private static final Logger logger = LoggerFactory.getLogger(WatchExample.class);

    public static void main(String[] args) throws InterruptedException {
        block30: {
            String master = "https://localhost:8443/";
            if (args.length == 1) {
                master = args[0];
            }
            final CountDownLatch closeLatch = new CountDownLatch(1);
            EditableConfig config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).withWatchReconnectLimit(2)).build();
            try (DefaultKubernetesClient client = new DefaultKubernetesClient((Config)config);){
                try (Watch watch = ((ClientNonNamespaceOperation)client.replicationControllers().inNamespace("default")).watch((Watcher)new Watcher<ReplicationController>(){

                    public void eventReceived(Watcher.Action action, ReplicationController resource) {
                        logger.info("{}: {}", (Object)action, (Object)resource.getMetadata().getResourceVersion());
                    }

                    public void onClose(KubernetesClientException e) {
                        if (e != null) {
                            logger.error(e.getMessage(), (Throwable)e);
                            closeLatch.countDown();
                        }
                    }
                });){
                    closeLatch.await(1L, TimeUnit.MINUTES);
                }
                catch (KubernetesClientException | InterruptedException e) {
                    logger.error("Could not watch resources", e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                Throwable[] suppressed = e.getSuppressed();
                if (suppressed == null) break block30;
                for (Throwable t : suppressed) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }
}

