/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.cache.ReflectorWatcher;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflector<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Reflector.class);
    private final AtomicReference<String> lastSyncResourceVersion;
    private final Class<T> apiTypeClass;
    private final ListerWatcher<T, L> listerWatcher;
    private final Store<T> store;
    private final OperationContext operationContext;
    private final ReflectorWatcher<T> watcher;
    private volatile boolean running = true;
    private final AtomicReference<Watch> watch;

    public Reflector(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, Store store, OperationContext operationContext) {
        this.apiTypeClass = apiTypeClass;
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.operationContext = operationContext;
        this.lastSyncResourceVersion = new AtomicReference();
        this.watcher = new ReflectorWatcher(store, this.lastSyncResourceVersion, this::listSyncAndWatch);
        this.watch = new AtomicReference<Object>(null);
    }

    private L getList() {
        return (L)((KubernetesResourceList)this.listerWatcher.list(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.FALSE)).withResourceVersion(null)).withTimeoutSeconds(null)).build(), this.operationContext.getNamespace(), this.operationContext));
    }

    public void stop() {
        this.running = false;
        this.stopWatcher();
    }

    private synchronized void stopWatcher() {
        Watch theWatch = this.watch.getAndSet(null);
        if (theWatch != null) {
            String ns = this.operationContext.getNamespace();
            log.debug("Stopping watcher for resource {} v{} in namespace {}", new Object[]{this.apiTypeClass, this.lastSyncResourceVersion.get(), ns});
            theWatch.close();
        }
    }

    void listSyncAndWatch() {
        this.store.isPopulated(false);
        L list = this.getList();
        String latestResourceVersion = list.getMetadata().getResourceVersion();
        this.lastSyncResourceVersion.set(list.getMetadata().getResourceVersion());
        log.debug("Listing items ({}) for resource {} v{}", new Object[]{list.getItems().size(), this.apiTypeClass, latestResourceVersion});
        this.store.replace(list.getItems(), latestResourceVersion);
        this.startWatcher(latestResourceVersion);
    }

    private synchronized void startWatcher(String latestResourceVersion) {
        if (!this.running) {
            return;
        }
        log.debug("Starting watcher for resource {} v{}", this.apiTypeClass, (Object)latestResourceVersion);
        this.watch.set(this.listerWatcher.watch(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.TRUE)).withResourceVersion(latestResourceVersion)).withTimeoutSeconds(null)).build(), this.operationContext.getNamespace(), this.operationContext, this.watcher));
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion.get();
    }

    public boolean isRunning() {
        return this.running;
    }
}

