/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import okhttp3.OkHttpClient;

public class CustomResourceOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends HasMetadataOperation<T, L, Resource<T>>
implements MixedOperation<T, L, Resource<T>> {
    private final boolean resourceNamespaced;

    public CustomResourceOperationsImpl(OkHttpClient client, Config config) {
        this(new CustomResourceOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public CustomResourceOperationsImpl(CustomResourceOperationContext context) {
        super(context.withApiGroupName(context.getCrdContext().getGroup()).withApiGroupVersion(context.getCrdContext().getVersion()).withPlural(context.getCrdContext().getPlural()));
        this.type = context.getType();
        this.listType = context.getListType() != null ? context.getListType() : KubernetesResourceUtil.inferListType(this.type);
        this.resourceNamespaced = CustomResourceOperationsImpl.resourceNamespaced(context.getCrdContext());
        this.apiVersion = this.getAPIGroup() + "/" + this.getAPIVersion();
        KubernetesDeserializer.registerCustomKind((String)this.apiVersion, (String)this.kind(context.getCrdContext()), (Class)this.type);
        if (KubernetesResource.class.isAssignableFrom(this.listType)) {
            KubernetesDeserializer.registerCustomKind((String)this.listType.getSimpleName(), (Class)this.listType);
        }
    }

    public CustomResourceOperationsImpl newInstance(OperationContext context) {
        return new CustomResourceOperationsImpl<T, L>((CustomResourceOperationContext)context);
    }

    protected static boolean resourceNamespaced(CustomResourceDefinitionContext crdContext) {
        return "Namespaced".equals(crdContext.getScope());
    }

    private String kind(CustomResourceDefinitionContext crdContext) {
        return crdContext.getKind() != null ? crdContext.getKind() : this.getKind();
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.resourceNamespaced;
    }
}

