/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.HasMetadataVisitiableBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAndCreateHelper<T extends HasMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteAndCreateHelper.class);
    private static final int MAX_WAIT_SECONDS = 30;
    private final UnaryOperator<T> createTask;
    private final Function<T, Boolean> awaitDeleteTask;
    private final Function<T, Boolean> deleteTask;

    public DeleteAndCreateHelper(UnaryOperator<T> createTask, Function<T, Boolean> deleteTask, Function<T, Boolean> awaitDeleteTask) {
        this.createTask = createTask;
        this.awaitDeleteTask = awaitDeleteTask;
        this.deleteTask = deleteTask;
    }

    public T deleteAndCreate(T item) {
        Boolean deleted = this.deleteTask.apply(item);
        if (!deleted.booleanValue()) {
            LOG.debug("did not delete because item did not exist, continuing to create {}", (Object)item.getMetadata().getName());
        }
        try {
            return (T)((HasMetadata)this.createTask.apply(item));
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 409) {
                if (!deleted.booleanValue()) {
                    LOG.error("there was no item to delete, but received HTTP_CONFLICT response upon creation of item {}", (Object)item.getMetadata().getName(), (Object)e);
                    throw e;
                }
                if (Boolean.FALSE.equals(this.awaitDeleteTask.apply(item))) {
                    throw new KubernetesClientException("Timed out waiting for item to be deleted before recreating: " + item.getMetadata().getName(), e);
                }
                return (T)((HasMetadata)this.createTask.apply(item));
            }
            throw e;
        }
    }

    public static HasMetadata deleteAndCreateItem(OkHttpClient client, Config config, HasMetadata meta, ResourceHandler<HasMetadata, HasMetadataVisitiableBuilder> h, String namespaceToUse, DeletionPropagation propagationPolicy) {
        DeleteAndCreateHelper<HasMetadata> deleteAndCreateHelper = new DeleteAndCreateHelper<HasMetadata>(m -> h.create(client, config, namespaceToUse, (HasMetadata)m), m -> h.delete(client, config, namespaceToUse, propagationPolicy, (HasMetadata)m), DeleteAndCreateHelper.waitUntilDeletedOrInterrupted(client, config, h, namespaceToUse));
        return deleteAndCreateHelper.deleteAndCreate(meta);
    }

    private static <T extends HasMetadata> Function<T, Boolean> waitUntilDeletedOrInterrupted(OkHttpClient client, Config config, ResourceHandler<HasMetadata, HasMetadataVisitiableBuilder> h, String namespaceToUse) {
        return m -> {
            try {
                return h.waitUntilCondition(client, config, namespaceToUse, (HasMetadata)m, Objects::isNull, 30L, TimeUnit.SECONDS) == null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("interrupted waiting for item to be deleted, assuming not deleted");
                return false;
            }
        };
    }
}

