/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.ScalableReaper;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollableScalableResourceOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R>
implements RollableScalableResource<T, D> {
    private final Logger Log = LoggerFactory.getLogger(this.getClass());
    final Boolean rolling;
    final long rollingTimeout;
    final TimeUnit rollingTimeUnit;

    public RollableScalableResourceOperation(OkHttpClient client, Config config, String apiVersionGroup, String apiVersionNumber, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        super(client, config, ApiVersionUtil.apiGroup(item, apiVersionGroup), ApiVersionUtil.apiVersion(item, apiVersionNumber), resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.rolling = rolling;
        this.rollingTimeout = rollingTimeout;
        this.rollingTimeUnit = rollingTimeUnit;
        this.reaper = new ScalableReaper(this);
    }

    abstract T withReplicas(int var1);

    abstract RollingUpdater<T, L, D> getRollingUpdater(long var1, TimeUnit var3);

    abstract int getCurrentReplicas(T var1);

    abstract int getDesiredReplicas(T var1);

    abstract long getObservedGeneration(T var1);

    @Override
    public T scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public T scale(int count, boolean wait) {
        Object res = this.withReplicas(count);
        if (wait) {
            this.waitUntilScaled(count);
            res = (HasMetadata)this.getMandatory();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable tPoller = () -> {
            try {
                HasMetadata t = (HasMetadata)this.get();
                if (t == null) {
                    if (count == 0) {
                        queue.put(true);
                    } else {
                        queue.put(new IllegalStateException("Can't wait for " + this.getType().getSimpleName() + ": " + name + " in namespace: " + namespace + " to scale. Resource is no longer available."));
                    }
                    return;
                }
                int currentReplicas = this.getCurrentReplicas(t);
                int desiredReplicas = this.getDesiredReplicas(t);
                replicasRef.set(currentReplicas);
                long generation = t.getMetadata().getGeneration() != null ? t.getMetadata().getGeneration() : -1L;
                long observedGeneration = this.getObservedGeneration(t);
                if (observedGeneration >= generation && Objects.equals(desiredReplicas, currentReplicas)) {
                    queue.put(true);
                }
                this.Log.debug("Only {}/{} replicas scheduled for {}: {} in namespace: {} seconds so waiting...", new Object[]{currentReplicas, desiredReplicas, t.getKind(), t.getMetadata().getName(), namespace});
            }
            catch (Throwable t) {
                this.Log.error("Error while waiting for resource to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(tPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.rollingTimeout, this.rollingTimeUnit)) {
                this.Log.debug("{}/{} pod(s) ready for {}: {} in namespace: {}.", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace});
            } else {
                this.Log.error("{}/{} pod(s) ready for {}: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace, this.rollingTimeUnit.toSeconds(this.rollingTimeout)});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public D edit() {
        if (!this.rolling.booleanValue()) {
            return super.edit();
        }
        Visitor visitor = t -> {
            try {
                this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate((HasMetadata)this.getMandatory(), (HasMetadata)t);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T t) {
        if (!this.rolling.booleanValue()) {
            return super.replace(t);
        }
        return (T)this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate((HasMetadata)this.getMandatory(), (HasMetadata)t);
    }

    @Override
    public T patch(T t) {
        if (!this.rolling.booleanValue()) {
            return super.patch(t);
        }
        return (T)this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate((HasMetadata)this.getMandatory(), (HasMetadata)t);
    }
}

