/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KubernetesResourceUtilTest {
    private ConfigMap configMap1;

    @Before
    public void createTestResource() {
        this.configMap1 = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("configmap1")).withNamespace("ns1")).withAnnotations(Collections.singletonMap("foo", "bar"))).withLabels(Collections.singletonMap("foo-label", "bar-label"))).endMetadata()).addToData("one", "1")).build();
    }

    @Test
    public void testNullSafeOperationsForName() {
        String resourceName = KubernetesResourceUtil.getName((HasMetadata)this.configMap1);
        Assert.assertNotNull((Object)resourceName);
        Assert.assertEquals((Object)"configmap1", (Object)resourceName);
    }

    @Test
    public void testNullSafeOperationsForNamespace() {
        String namespace = KubernetesResourceUtil.getNamespace((HasMetadata)this.configMap1);
        Assert.assertNotNull((Object)namespace);
        Assert.assertEquals((Object)"ns1", (Object)namespace);
        Assert.assertEquals((Object)"ns1/configmap1", (Object)KubernetesResourceUtil.getQualifiedName((HasMetadata)this.configMap1));
    }

    @Test
    public void testNullSafeOperationsForLabels() {
        Map labels = KubernetesResourceUtil.getOrCreateLabels((HasMetadata)this.configMap1);
        Assert.assertNotNull((Object)labels);
        Assert.assertEquals(Collections.singletonMap("foo-label", "bar-label"), (Object)labels);
    }

    @Test
    public void testNullSafeOperationsForAnnotations() {
        Map annos = KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1);
        Assert.assertNotNull((Object)annos);
        Assert.assertEquals(Collections.singletonMap("foo", "bar"), (Object)annos);
    }

    @Test
    public void testNames() {
        Assert.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.getName((HasMetadata)this.configMap1)));
        Assert.assertFalse((boolean)KubernetesResourceUtil.isValidName((String)"test.invalid.name"));
        Assert.assertTrue((boolean)KubernetesResourceUtil.isValidLabelOrAnnotation((Map)KubernetesResourceUtil.getOrCreateAnnotations((HasMetadata)this.configMap1)));
        Assert.assertFalse((boolean)KubernetesResourceUtil.isValidLabelOrAnnotation(Collections.singletonMap("NoUppercaseOrSpecialCharsLike=Equals", "bar")));
        Assert.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"test.invalid.name")));
        Assert.assertTrue((boolean)KubernetesResourceUtil.isValidName((String)KubernetesResourceUtil.sanitizeName((String)"90notcool-n@me")));
    }
}

