/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.ReplaceValueStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public class Serialization {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static <T> String asJson(T object) throws KubernetesClientException {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> String asYaml(T object) throws KubernetesClientException {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is) throws KubernetesClientException {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    public static <T> T unmarshal(InputStream is, Map<String, String> parameters) throws KubernetesClientException {
        return Serialization.unmarshal(is, JSON_MAPPER, parameters);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readerFor(KubernetesResource.class).readValue((InputStream)bis);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(String str, Class<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(str, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, final Class<T> type, Map<String, String> parameters) throws KubernetesClientException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            }, parameters);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    public static <T> T unmarshal(InputStream is, final Class<T> type, Map<String, String> parameters) throws KubernetesClientException {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        }, parameters);
    }

    public static <T> T unmarshal(InputStream is, TypeReference<T> type) throws KubernetesClientException {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, TypeReference<T> type, Map<String, String> parameters) throws KubernetesClientException {
        InputStream wrapped = parameters != null && !parameters.isEmpty() ? new ReplaceValueStream(parameters).createInputStream(is) : is;
        try (BufferedInputStream bis = new BufferedInputStream(wrapped);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = JSON_MAPPER;
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readValue((InputStream)bis, type);
            return (T)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

