/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;

public class HasMetadataOperation<C extends Client, T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends BaseOperation<C, T, L, D, R> {
    protected HasMetadataOperation(C client, String resourceT, String namespace, String name, Boolean cascading, T item) {
        super(client, resourceT, namespace, name, cascading, item);
    }

    protected HasMetadataOperation(C client, String resourceT, String namespace, String name, Boolean cascading, T item, Class<T> type, Class<L> listType, Class<D> doneableType) {
        super(client, resourceT, namespace, name, cascading, item, type, listType, doneableType);
    }

    @Override
    public D edit() throws KubernetesClientException {
        final HasMetadataOperation oper = this;
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    Reaper reaper;
                    if (HasMetadataOperation.this.isCascading().booleanValue() && !HasMetadataOperation.this.isReaping() && (reaper = ReaperFactory.getReaper(oper)) != null) {
                        HasMetadataOperation.this.setReaping(true);
                        reaper.reap();
                    }
                    HasMetadataOperation.this.replace(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            HasMetadata item = (HasMetadata)this.getMandatory();
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(item, visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T item) {
        Exception caught = null;
        int maxTries = 5;
        for (int i = 0; i < maxTries; ++i) {
            try {
                Reaper reaper;
                if (this.isCascading().booleanValue() && (reaper = ReaperFactory.getReaper(this)) != null && !this.isReaping()) {
                    this.setReaping(true);
                    reaper.reap();
                }
                item.getMetadata().setResourceVersion(((HasMetadata)this.get()).getMetadata().getResourceVersion());
                return (T)((HasMetadata)this.handleReplace(this.getResourceUrl(), item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(caught);
    }
}

