/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DoneableKubernetesList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Creators;
import io.fabric8.kubernetes.client.GenericKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceCreator;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListOperation;
import io.fabric8.kubernetes.client.dsl.CreateGettable;
import io.fabric8.kubernetes.client.dsl.Loadable;
import java.io.InputStream;
import java.util.ArrayList;

public class KubernetesListOperationsImpl<C extends GenericKubernetesClient<C>>
implements ClientKubernetesListOperation<C>,
ClientKubernetesListMixedOperation<C>,
Loadable<InputStream, CreateGettable<KubernetesList, KubernetesList, DoneableKubernetesList>>,
CreateGettable<KubernetesList, KubernetesList, DoneableKubernetesList> {
    private final C client;
    private KubernetesList item;
    private String namespace;

    public KubernetesListOperationsImpl(C client) {
        this(client, client.getNamespace());
    }

    public KubernetesListOperationsImpl(C client, String namespace) {
        this.client = client;
        this.namespace = namespace;
    }

    @Override
    public C getClient() {
        return this.client;
    }

    @Override
    public ClientKubernetesListNonNamespaceOperation<C> inNamespace(String namespace) {
        return new KubernetesListOperationsImpl<C>(this.client, namespace);
    }

    public KubernetesList create(KubernetesList ... items) {
        ArrayList<HasMetadata> createdItems = new ArrayList<HasMetadata>();
        for (KubernetesList i : items) {
            for (HasMetadata r : i.getItems()) {
                HasMetadata created = this.create(r);
                createdItems.add(created);
            }
        }
        KubernetesList createdList = new KubernetesList();
        createdList.setItems(createdItems);
        return createdList;
    }

    @Override
    public DoneableKubernetesList createNew() {
        return new DoneableKubernetesList((Visitor)new Visitor<KubernetesList>(){

            public void visit(KubernetesList list) {
                try {
                    KubernetesListOperationsImpl.this.create(list);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        });
    }

    @Override
    public CreateGettable<KubernetesList, KubernetesList, DoneableKubernetesList> load(InputStream is) {
        this.item = this.client.unmarshal(is, KubernetesList.class);
        return this;
    }

    @Override
    public KubernetesList get() {
        return this.item;
    }

    private <T extends HasMetadata> T create(T resource) {
        ResourceCreator<?> creator = Creators.get(resource.getClass());
        if (creator != null) {
            return (T)creator.create((Client)this.client, this.namespace, resource);
        }
        throw new IllegalStateException("Could not find creator");
    }
}

