/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio;

import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.Channel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFactory;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFuture;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelPipeline;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelSink;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.SocketChannel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio.DefaultNioSocketChannelConfig;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio.NioWorker;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioSocketChannel
extends AbstractNioChannel<java.nio.channels.SocketChannel>
implements SocketChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    volatile int state = 0;
    private final NioSocketChannelConfig config;

    public NioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, java.nio.channels.SocketChannel socket, NioWorker worker) {
        super(parent, factory, pipeline, sink, worker, socket);
        this.config = new DefaultNioSocketChannelConfig(socket.socket());
    }

    @Override
    public NioWorker getWorker() {
        return (NioWorker)super.getWorker();
    }

    @Override
    public NioSocketChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state >= 0;
    }

    @Override
    public boolean isBound() {
        return this.state >= 1;
    }

    @Override
    public boolean isConnected() {
        return this.state == 2;
    }

    final void setBound() {
        assert (this.state == 0) : "Invalid state: " + this.state;
        this.state = 1;
    }

    final void setConnected() {
        if (this.state != -1) {
            this.state = 2;
        }
    }

    @Override
    protected boolean setClosed() {
        if (super.setClosed()) {
            this.state = -1;
            return true;
        }
        return false;
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.SocketChannel)this.channel).socket().getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.SocketChannel)this.channel).socket().getRemoteSocketAddress();
    }

    @Override
    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }
}

