/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.resumable;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHandler;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.HttpResponseBodyPart;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.HttpResponseHeaders;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.HttpResponseStatus;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Request;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.RequestBuilder;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Response;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.listener.TransferCompletionHandler;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.resumable.PropertiesBasedResumableProcessor;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.resumable.ResumableListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableAsyncHandler<T>
implements AsyncHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private final AtomicLong byteTransferred;
    private String url;
    private final ResumableProcessor resumableProcessor;
    private final AsyncHandler<T> decoratedAsyncHandler;
    private static Map<String, Long> resumableIndex;
    private static final ResumableIndexThread resumeIndexThread;
    private Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
    private final boolean accumulateBody;
    private ResumableListener resumableListener = new NULLResumableListener();

    private ResumableAsyncHandler(long byteTransferred, ResumableProcessor resumableProcessor, AsyncHandler<T> decoratedAsyncHandler, boolean accumulateBody) {
        this.byteTransferred = new AtomicLong(byteTransferred);
        if (resumableProcessor == null) {
            resumableProcessor = new NULLResumableHandler();
        }
        this.resumableProcessor = resumableProcessor;
        resumableIndex = resumableProcessor.load();
        resumeIndexThread.addResumableProcessor(resumableProcessor);
        this.decoratedAsyncHandler = decoratedAsyncHandler;
        this.accumulateBody = accumulateBody;
    }

    public ResumableAsyncHandler(long byteTransferred) {
        this(byteTransferred, null, null, false);
    }

    public ResumableAsyncHandler(boolean accumulateBody) {
        this(0L, null, null, accumulateBody);
    }

    public ResumableAsyncHandler() {
        this(0L, null, null, false);
    }

    public ResumableAsyncHandler(AsyncHandler<T> decoratedAsyncHandler) {
        this(0L, new PropertiesBasedResumableProcessor(), decoratedAsyncHandler, false);
    }

    public ResumableAsyncHandler(long byteTransferred, AsyncHandler<T> decoratedAsyncHandler) {
        this(byteTransferred, new PropertiesBasedResumableProcessor(), decoratedAsyncHandler, false);
    }

    public ResumableAsyncHandler(ResumableProcessor resumableProcessor) {
        this(0L, resumableProcessor, null, false);
    }

    public ResumableAsyncHandler(ResumableProcessor resumableProcessor, boolean accumulateBody) {
        this(0L, resumableProcessor, null, accumulateBody);
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.responseBuilder.accumulate(status);
        if (status.getStatusCode() != 200 && status.getStatusCode() != 206) {
            return AsyncHandler.STATE.ABORT;
        }
        this.url = status.getUri().toUrl();
        if (this.decoratedAsyncHandler != null) {
            return this.decoratedAsyncHandler.onStatusReceived(status);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public void onThrowable(Throwable t) {
        if (this.decoratedAsyncHandler != null) {
            this.decoratedAsyncHandler.onThrowable(t);
        } else {
            logger.debug("", t);
        }
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (this.accumulateBody) {
            this.responseBuilder.accumulate(bodyPart);
        }
        AsyncHandler.STATE state = AsyncHandler.STATE.CONTINUE;
        try {
            this.resumableListener.onBytesReceived(bodyPart.getBodyByteBuffer());
        }
        catch (IOException ex) {
            return AsyncHandler.STATE.ABORT;
        }
        if (this.decoratedAsyncHandler != null) {
            state = this.decoratedAsyncHandler.onBodyPartReceived(bodyPart);
        }
        this.byteTransferred.addAndGet(bodyPart.getBodyPartBytes().length);
        this.resumableProcessor.put(this.url, this.byteTransferred.get());
        return state;
    }

    @Override
    public T onCompleted() throws Exception {
        this.resumableProcessor.remove(this.url);
        this.resumableListener.onAllBytesReceived();
        if (this.decoratedAsyncHandler != null) {
            this.decoratedAsyncHandler.onCompleted();
        }
        return (T)this.responseBuilder.build();
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.responseBuilder.accumulate(headers);
        String contentLengthHeader = headers.getHeaders().getFirstValue("Content-Length");
        if (contentLengthHeader != null && Long.parseLong(contentLengthHeader) == -1L) {
            return AsyncHandler.STATE.ABORT;
        }
        if (this.decoratedAsyncHandler != null) {
            return this.decoratedAsyncHandler.onHeadersReceived(headers);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public Request adjustRequestRange(Request request) {
        Long ri = resumableIndex.get(request.getUrl());
        if (ri != null) {
            this.byteTransferred.set(ri);
        }
        if (this.resumableListener != null && this.resumableListener.length() > 0L && this.byteTransferred.get() != this.resumableListener.length()) {
            this.byteTransferred.set(this.resumableListener.length());
        }
        RequestBuilder builder = new RequestBuilder(request);
        if (request.getHeaders().get("Range").isEmpty() && this.byteTransferred.get() != 0L) {
            builder.setHeader("Range", "bytes=" + this.byteTransferred.get() + "-");
        }
        return builder.build();
    }

    public ResumableAsyncHandler setResumableListener(ResumableListener resumableListener) {
        this.resumableListener = resumableListener;
        return this;
    }

    static {
        resumeIndexThread = new ResumableIndexThread();
    }

    private static class NULLResumableListener
    implements ResumableListener {
        private long length = 0L;

        private NULLResumableListener() {
        }

        @Override
        public void onBytesReceived(ByteBuffer byteBuffer) throws IOException {
            this.length += (long)byteBuffer.remaining();
        }

        @Override
        public void onAllBytesReceived() {
        }

        @Override
        public long length() {
            return this.length;
        }
    }

    private static class NULLResumableHandler
    implements ResumableProcessor {
        private NULLResumableHandler() {
        }

        @Override
        public void put(String url, long transferredBytes) {
        }

        @Override
        public void remove(String uri) {
        }

        @Override
        public void save(Map<String, Long> map) {
        }

        @Override
        public Map<String, Long> load() {
            return new HashMap<String, Long>();
        }
    }

    public static interface ResumableProcessor {
        public void put(String var1, long var2);

        public void remove(String var1);

        public void save(Map<String, Long> var1);

        public Map<String, Long> load();
    }

    private static class ResumableIndexThread
    extends Thread {
        public final ConcurrentLinkedQueue<ResumableProcessor> resumableProcessors = new ConcurrentLinkedQueue();

        public ResumableIndexThread() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void addResumableProcessor(ResumableProcessor p) {
            this.resumableProcessors.offer(p);
        }

        @Override
        public void run() {
            for (ResumableProcessor p : this.resumableProcessors) {
                p.save(resumableIndex);
            }
        }
    }
}

