/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.timeout;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.NettyRequestSender;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.timeout.TimeoutTimerTask;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.timeout.TimeoutsHolder;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.DateUtils;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.util.Timeout;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    public RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, long requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        String message = "Request timed out to " + this.remoteAddress + " of " + this.requestTimeout + " ms";
        long age = DateUtils.millisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

