/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio;

import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio.AbstractNioBossPool;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.socket.nio.NioClientBoss;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.util.HashedWheelTimer;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.util.ThreadNameDeterminer;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.util.Timer;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioClientBossPool
extends AbstractNioBossPool<NioClientBoss> {
    private final ThreadNameDeterminer determiner;
    private final Timer timer;
    private boolean stopTimer;

    public NioClientBossPool(Executor bossExecutor, int bossCount, Timer timer, ThreadNameDeterminer determiner) {
        super(bossExecutor, bossCount, false);
        this.determiner = determiner;
        this.timer = timer;
        this.init();
    }

    public NioClientBossPool(Executor bossExecutor, int bossCount) {
        this(bossExecutor, bossCount, new HashedWheelTimer(), null);
        this.stopTimer = true;
    }

    @Override
    protected NioClientBoss newBoss(Executor executor) {
        return new NioClientBoss(executor, this.timer, this.determiner);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.stopTimer) {
            this.timer.stop();
        }
    }

    @Override
    public void releaseExternalResources() {
        super.releaseExternalResources();
        this.timer.stop();
    }
}

