/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.EditableContainer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ImageEditReplaceable;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.RollingUpdater;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;

public class RollingOperation
extends BaseOperation<KubernetesClient, ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientResource<ReplicationController, DoneableReplicationController>>
implements ImageEditReplaceable<ReplicationController, ReplicationController, DoneableReplicationController> {
    public RollingOperation(KubernetesClient client, String namespace, String name) {
        super(client, "replicationcontrollers", namespace, name);
    }

    @Override
    public ReplicationController image(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        EditableContainer updatedContainer = ((ContainerBuilder)new ContainerBuilder((Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicationControllerBuilder newRCBuilder = new ReplicationControllerBuilder(oldRC);
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new RollingUpdater((KubernetesClient)this.getClient()).rollUpdate(oldRC, (ReplicationController)newRCBuilder.build());
    }

    @Override
    public DoneableReplicationController edit() {
        Visitor<ReplicationController> visitor = new Visitor<ReplicationController>(){

            public void visit(ReplicationController rc) {
                try {
                    new RollingUpdater((KubernetesClient)RollingOperation.this.getClient()).rollUpdate((ReplicationController)RollingOperation.this.get(), rc);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (DoneableReplicationController)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public ReplicationController replace(ReplicationController rc) {
        return new RollingUpdater((KubernetesClient)this.getClient()).rollUpdate((ReplicationController)this.get(), rc);
    }

    @Override
    public ReplicationController update(ReplicationController item) {
        return this.replace(item);
    }
}

