/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.ProxyServer;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.uri.Uri;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.AsyncHttpProviderUtils;

public interface ConnectionPoolPartitioning {
    public Object getPartitionKey(Uri var1, ProxyServer var2);

    public static enum PerHostConnectionPoolPartitioning implements ConnectionPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, ProxyServer proxyServer) {
            String targetHostBaseUrl = AsyncHttpProviderUtils.getBaseUrl(uri);
            return proxyServer != null ? new ProxyPartitionKey(proxyServer.getUrl(), targetHostBaseUrl) : targetHostBaseUrl;
        }
    }

    public static class ProxyPartitionKey {
        private final String proxyUrl;
        private final String targetHostBaseUrl;

        public ProxyPartitionKey(String proxyUrl, String targetHostBaseUrl) {
            this.proxyUrl = proxyUrl;
            this.targetHostBaseUrl = targetHostBaseUrl;
        }

        public String toString() {
            return "ProxyPartitionKey(proxyUrl=" + this.proxyUrl + ", targetHostBaseUrl=" + this.targetHostBaseUrl;
        }
    }
}

