/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import java.lang.reflect.InvocationTargetException;

public class HasMetadataOperation<C extends KubernetesClient, T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends BaseOperation<C, T, L, D, R> {
    protected HasMetadataOperation(C client, String resourceT, String namespace, String name) {
        super(client, resourceT, namespace, name);
    }

    @Override
    public D edit(final boolean cascade) throws KubernetesClientException {
        final HasMetadataOperation oper = this;
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    Reaper reaper;
                    if (cascade && (reaper = ReaperFactory.getReaper(oper)) != null) {
                        reaper.reap();
                    }
                    resource.getMetadata().setResourceVersion(null);
                    HasMetadataOperation.this.handleReplace(HasMetadataOperation.this.getResourceUrl(), resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T item, boolean cascade) {
        try {
            Reaper reaper;
            if (cascade && (reaper = ReaperFactory.getReaper(this)) != null) {
                reaper.reap();
            }
            item.getMetadata().setResourceVersion(null);
            return (T)((HasMetadata)this.handleReplace(this.getResourceUrl(), item));
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

