/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.socks;

import io.fabric8.kubernetes.client.internal.org.jboss.netty.buffer.ChannelBuffer;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.Channel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelHandlerContext;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.socks.SocksCommonUtils;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.socks.SocksInitRequest;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.socks.SocksMessage;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.socks.SocksRequest;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksInitRequestDecoder
extends ReplayingDecoder<State> {
    private final List<SocksMessage.AuthScheme> authSchemes = new ArrayList<SocksMessage.AuthScheme>();
    private SocksMessage.ProtocolVersion version;
    private byte authSchemeNum;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public SocksInitRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_AUTH_SCHEMES);
            }
            case READ_AUTH_SCHEMES: {
                this.authSchemes.clear();
                this.authSchemeNum = buffer.readByte();
                for (int i = 0; i < this.authSchemeNum; ++i) {
                    this.authSchemes.add(SocksMessage.AuthScheme.fromByte(buffer.readByte()));
                }
                this.msg = new SocksInitRequest(this.authSchemes);
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_SCHEMES;

    }
}

