/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.BuildConfigResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import java.net.URL;

public class BuildConfigOperationsImpl
extends BaseOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig>>
implements BuildConfigResource<BuildConfig, DoneableBuildConfig>,
Typeable<Triggerable<WebHookTrigger>>,
Triggerable<WebHookTrigger> {
    private final String secret;
    private final String triggerType;

    public BuildConfigOperationsImpl(AsyncHttpClient httpClient, URL rootUrl, String secret, String triggerType) {
        super(httpClient, rootUrl, "buildconfigs", null, null, BuildConfig.class, BuildConfigList.class, DoneableBuildConfig.class);
        this.triggerType = triggerType;
        this.secret = secret;
    }

    public BuildConfigOperationsImpl(AsyncHttpClient httpClient, URL rootUrl, String namespace, String name, String secret, String triggerType) {
        super(httpClient, rootUrl, "buildconfigs", namespace, name);
        this.triggerType = triggerType;
        this.secret = secret;
    }

    @Override
    public BuildConfigResource<BuildConfig, DoneableBuildConfig> withName(String name) {
        try {
            return (BuildConfigResource)this.getClass().getConstructor(AsyncHttpClient.class, URL.class, String.class, String.class, String.class, String.class).newInstance(this.getHttpClient(), this.getRootUrl(), this.getNamespace(), name, this.secret, this.triggerType);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public NonNamespaceOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig>> inNamespace(String namespace) {
        try {
            return (NonNamespaceOperation)this.getClass().getConstructor(AsyncHttpClient.class, URL.class, String.class, String.class, String.class, String.class).newInstance(this.getHttpClient(), this.getRootUrl(), namespace, this.getName(), this.secret, this.triggerType);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public Typeable<Triggerable<WebHookTrigger>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.getHttpClient(), this.getRootUrl(), this.getNamespace(), this.getName(), secret, this.triggerType);
    }

    @Override
    public void instantiate(BuildRequest request) {
        try {
            URL instantiationUrl = new URL(this.getResourceUrl().toString() + "/instantiate");
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getHttpClient().preparePost(instantiationUrl.toString());
            requestBuilder.setBody(mapper.writer().writeValueAsString((Object)request));
            this.handleResponse(requestBuilder, 201);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void trigger(WebHookTrigger trigger) {
        try {
            URL webhooksUrl = new URL(this.getResourceUrl().toString() + "/webhooks/");
            URL triggerUrl = new URL(webhooksUrl, this.secret + "/" + this.triggerType);
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getHttpClient().preparePost(triggerUrl.toString());
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.addHeader("X-Github-Event", "push");
            requestBuilder.setBody(mapper.writer().writeValueAsString((Object)trigger));
            ListenableFuture f = requestBuilder.execute();
            Response r = (Response)f.get();
            if (r.getStatusCode() != 200) {
                Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
                throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Triggerable<WebHookTrigger> withType(String type) {
        return new BuildConfigOperationsImpl(this.getHttpClient(), this.getRootUrl(), this.getNamespace(), this.getName(), this.secret, type);
    }
}

