/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ProcessableResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseProcessableOperation;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import java.net.MalformedURLException;
import java.net.URL;

public class TemplateOperationsImpl
extends BaseProcessableOperation<Template, TemplateList, DoneableTemplate, ProcessableResource<Template, DoneableTemplate>> {
    public TemplateOperationsImpl(AsyncHttpClient httpClient, URL rootUrl) {
        super(httpClient, rootUrl, "templates", null, null, Template.class, TemplateList.class, DoneableTemplate.class);
    }

    public TemplateOperationsImpl(AsyncHttpClient httpClient, URL rootUrl, String namespace, String name) {
        super(httpClient, rootUrl, "templates", namespace, name);
    }

    @Override
    public Template process(Template item) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = null;
        try {
            requestBuilder = this.getHttpClient().preparePost(this.getProcessUrl().toString());
            requestBuilder.setBody(mapper.writer().writeValueAsString((Object)item));
            return (Template)this.handleResponse(requestBuilder, 201);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private URL getProcessUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(requestUrl, "namespaces/" + this.getNamespace() + "/");
        }
        requestUrl = new URL(requestUrl, "processedtemplates/");
        return requestUrl;
    }
}

