/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.YamlDumpSettingsBuilder;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class KubernetesSerializationTest {
    private KubernetesSerialization kubernetesSerialization;

    KubernetesSerializationTest() {
    }

    @Version(value="v1")
    @Group(value="custom.core.kubernetes.io")
    @JsonDeserialize(using=JsonDeserializer.None.class)
    public static class Pod
    implements HasMetadata {
        @JsonProperty(value="apiVersion")
        private String apiVersion = "custom.core.kubernetes.io/v1";
        @JsonProperty(value="kind")
        private String kind = "Pod";

        public ObjectMeta getMetadata() {
            return null;
        }

        public void setMetadata(ObjectMeta metadata) {
        }

        public void setApiVersion(String version) {
        }
    }

    @Nested
    class AsYaml {
        private CustomResourceDefinition inputResource;

        AsYaml() {
        }

        @BeforeEach
        void loadYamlAsString() throws IOException {
            try (InputStream is = KubernetesSerializationTest.class.getResourceAsStream("/serialization/test-crd-schema.yml");){
                this.inputResource = (CustomResourceDefinition)Serialization.unmarshal((String)new String(is.readAllBytes()), CustomResourceDefinition.class);
            }
        }

        @Test
        void asYamlWithDefaults() {
            Assertions.assertThat((String)new KubernetesSerialization().asYaml((Object)this.inputResource)).contains(new CharSequence[]{"\"widgets.test.fabric8.io\""});
        }

        @Test
        void asYamlWithDefaultYamlDumpSettings() {
            KubernetesSerializationTest.this.kubernetesSerialization = new KubernetesSerialization(new ObjectMapper(), true, new YamlDumpSettingsBuilder().build());
            Assertions.assertThat((String)KubernetesSerializationTest.this.kubernetesSerialization.asYaml((Object)this.inputResource)).contains(new CharSequence[]{"\"widgets.test.fabric8.io\""});
        }

        @Test
        void asYamlWithDefaultYamlDumpSettingsMinimizeQuotes() {
            KubernetesSerializationTest.this.kubernetesSerialization = new KubernetesSerialization(new ObjectMapper(), true, new YamlDumpSettingsBuilder().setMinimizeQuotes(true).build());
            Assertions.assertThat((String)KubernetesSerializationTest.this.kubernetesSerialization.asYaml((Object)this.inputResource)).contains(new CharSequence[]{"widgets.test.fabric8.io"});
        }
    }

    @Nested
    @DisplayName(value="with searchClassloaders=false")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class NoSearchClassLoaders {
        NoSearchClassLoaders() {
        }

        @BeforeEach
        void setUp() {
            KubernetesSerializationTest.this.kubernetesSerialization = new KubernetesSerialization(new ObjectMapper(), false);
        }

        @Test
        void shouldDeserializeToGeneric() {
            ((ObjectAssert)Assertions.assertThat((Object)KubernetesSerializationTest.this.kubernetesSerialization.unmarshal("{\"kind\":\"Pod\", \"apiVersion\":\"v1\"}")).isNotInstanceOf(io.fabric8.kubernetes.api.model.Pod.class)).isInstanceOf(GenericKubernetesResource.class);
        }

        @Test
        void withRegisteredKubernetesResourceShouldDeserializeToPod() {
            KubernetesSerializationTest.this.kubernetesSerialization.registerKubernetesResource(io.fabric8.kubernetes.api.model.Pod.class);
            Assertions.assertThat((Object)KubernetesSerializationTest.this.kubernetesSerialization.unmarshal("{\"kind\":\"Pod\", \"apiVersion\":\"v1\"}")).isInstanceOf(io.fabric8.kubernetes.api.model.Pod.class);
        }

        @ParameterizedTest(name="{index}: {0} {1} deserializes to {2}")
        @MethodSource(value={"sameGVK"})
        void withCollidingRegisteredKubernetesResourceShouldDeserializeAppropriate(String apiVersion, String kind, Class<?> expectedClass) {
            KubernetesSerializationTest.this.kubernetesSerialization.registerKubernetesResource(Pod.class);
            KubernetesSerializationTest.this.kubernetesSerialization.registerKubernetesResource(io.fabric8.kubernetes.api.model.Pod.class);
            Assertions.assertThat((Object)KubernetesSerializationTest.this.kubernetesSerialization.unmarshal("{\"kind\":\"" + kind + "\", \"apiVersion\":\"" + apiVersion + "\"}")).isInstanceOf(expectedClass);
        }

        private Stream<Arguments> sameGVK() {
            return Stream.of(Arguments.of((Object[])new Object[]{"v1", "Pod", io.fabric8.kubernetes.api.model.Pod.class}), Arguments.of((Object[])new Object[]{"v2", "Pod", GenericKubernetesResource.class}), Arguments.of((Object[])new Object[]{"custom.core.kubernetes.io/v1", "Pod", Pod.class}), Arguments.of((Object[])new Object[]{"custom.core.kubernetes.io/v2", "Pod", GenericKubernetesResource.class}), Arguments.of((Object[])new Object[]{"customs.core.kubernetes.io/v1", "Pod", GenericKubernetesResource.class}), Arguments.of((Object[])new Object[]{"custom.core.kubernetes.io/v1", "Pods", GenericKubernetesResource.class}));
        }
    }
}

