/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class ApiVersionUtilTest {
    ApiVersionUtilTest() {
    }

    @Test
    void apiGroup() {
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiGroup((Object)new Deployment(), (String)"apps/v1")).isEqualTo("apps");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiGroup((Object)new DeploymentSpec(), (String)"apps/v1")).isEqualTo("apps");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiGroup((Object)new Pod(), (String)"v1")).isNull();
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiGroup((Object)new DeploymentSpec(), (String)"")).isNull();
    }

    @Test
    void apiVersion() {
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiVersion((Object)new Deployment(), (String)"apps/v1")).isEqualTo("v1");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiVersion((Object)new DeploymentSpec(), (String)"apps/v1")).isEqualTo("v1");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiVersion((Object)new Pod(), (String)"v1")).isEqualTo("v1");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.apiVersion((Object)new DeploymentSpec(), (String)"")).isNull();
    }

    @Test
    void joinApiGroupAndVersion() {
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.joinApiGroupAndVersion((String)"", (String)"v1")).isEqualTo("v1");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.joinApiGroupAndVersion((String)"apps", (String)"v1")).isEqualTo("apps/v1");
    }

    @Test
    void trimVersion() {
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.trimVersion((String)"rbac.authorization.k8s.io/v1")).isEqualTo("v1");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.trimVersion((String)"v1")).isEqualTo("v1");
    }

    @Test
    void trimGroup() {
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.trimGroup((String)"rbac.authorization.k8s.io/v1")).isEqualTo("rbac.authorization.k8s.io");
        AssertionsForClassTypes.assertThat((String)ApiVersionUtil.trimGroup((String)"v1")).isEqualTo("v1");
    }
}

