/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigBuilder;
import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecConfigBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class KubeConfigUtilsTest {
    @TempDir
    private Path tempDir;

    KubeConfigUtilsTest() {
    }

    @Test
    @DisplayName(value="should create expected authenticator command for aws")
    void getAuthenticatorCommandFromExecConfig_whenAwsCommandUsed_thenUseCommandLineArgsInExecCommand() throws IOException {
        Path commandFile = Files.createFile(this.tempDir.resolve("aws"), new FileAttribute[0]);
        String systemPathValue = this.getTestPathValue(this.tempDir.toFile());
        ExecConfig execConfig = ((ExecConfigBuilder)((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().withApiVersion("client.authentication.k8s.io/v1alpha1")).addToArgs(new String[]{"--region", "us-west2", "eks", "get-token", "--cluster-name", "api-eks.example.com"})).withCommand("aws")).build();
        List processBuilderArgs = KubeConfigUtils.getAuthenticatorCommandFromExecConfig((ExecConfig)execConfig, (File)new File("~/.kube/config"), (String)systemPathValue);
        ((ListAssert)Assertions.assertThat((List)processBuilderArgs).isNotNull()).hasSize(3);
        this.assertPlatformPrefixes(processBuilderArgs);
        List<String> commandParts = Arrays.asList(((String)processBuilderArgs.get(2)).split(" "));
        Assertions.assertThat(commandParts).containsExactly((Object[])new String[]{commandFile.toFile().getAbsolutePath(), "--region", "us-west2", "eks", "get-token", "--cluster-name", "api-eks.example.com"});
    }

    @Test
    @DisplayName(value="should generate expected authenticator command for gke-gcloud-auth-plugin")
    void getAuthenticatorCommandFromExecConfig_whenGkeAuthPluginCommandProvided_thenUseCommandLineArgs() throws IOException {
        Path commandFile = Files.createFile(this.tempDir.resolve("gke-gcloud-auth-plugin"), new FileAttribute[0]);
        String systemPathValue = this.getTestPathValue(this.tempDir.toFile());
        ExecConfig execConfigNoArgs = ((ExecConfigBuilder)((ExecConfigBuilder)new ExecConfigBuilder().withApiVersion("client.authentication.k8s.io/v1alpha1")).withCommand(commandFile.toFile().getPath())).build();
        execConfigNoArgs.setArgs(null);
        List processBuilderArgs = KubeConfigUtils.getAuthenticatorCommandFromExecConfig((ExecConfig)execConfigNoArgs, null, (String)systemPathValue);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)processBuilderArgs).isNotNull()).hasSize(3)).satisfies(new ThrowingConsumer[]{pb -> Assertions.assertThat((String)((String)pb.get(2))).isEqualTo(commandFile.toFile().getPath())});
        this.assertPlatformPrefixes(processBuilderArgs);
    }

    private void assertPlatformPrefixes(List<String> processBuilderArgs) {
        List platformArgsExpected = Utils.getCommandPlatformPrefix();
        ((ListAssert)Assertions.assertThat(processBuilderArgs).satisfies(new ThrowingConsumer[]{p -> Assertions.assertThat((String)((String)p.get(0))).isEqualTo((String)platformArgsExpected.get(0))})).satisfies(new ThrowingConsumer[]{p -> Assertions.assertThat((String)((String)p.get(1))).isEqualTo((String)platformArgsExpected.get(1))});
    }

    private String getTestPathValue(File commandFolder) {
        if (Utils.isWindowsOperatingSystem()) {
            return "C:\\Program Files\\Java\\jdk14.0_23\\bin" + File.pathSeparator + commandFolder.getAbsolutePath() + File.pathSeparator + "C:\\Program Files\\Apache Software Foundation\\apache-maven-3.3.1";
        }
        return "/usr/java/jdk-14.0.1/bin" + File.pathSeparator + commandFolder.getAbsolutePath() + File.pathSeparator + "/opt/apache-maven/bin";
    }

    @Nested
    @DisplayName(value="getFileWithNamedContextInfo")
    class GetFileWithNamedContextInfo {
        GetFileWithNamedContextInfo() {
        }

        @Test
        void withNullNamedContext() {
            Assertions.assertThat((File)KubeConfigUtils.getFileWithNamedContext(null)).isNull();
        }

        @Test
        void withNullAdditionalProperties() {
            NamedContext context = new NamedContext();
            context.setAdditionalProperties(null);
            Assertions.assertThat((File)KubeConfigUtils.getFileWithNamedContext((NamedContext)context)).isNull();
        }

        @Test
        void withEmptyAdditionalProperties() {
            NamedContext context = new NamedContext();
            Assertions.assertThat((File)KubeConfigUtils.getFileWithNamedContext((NamedContext)context)).isNull();
        }

        @Test
        void withNullValue() {
            NamedContext context = new NamedContext();
            context.setAdditionalProperty("KUBERNETES_CONFIG_CONTEXT_FILE_KEY", null);
            Assertions.assertThat((File)KubeConfigUtils.getFileWithNamedContext((NamedContext)context)).isNull();
        }

        @Test
        void withInvalidValue() {
            NamedContext context = new NamedContext();
            context.setAdditionalProperty("KUBERNETES_CONFIG_CONTEXT_FILE_KEY", (Object)"not-file");
            Assertions.assertThat((File)KubeConfigUtils.getFileWithNamedContext((NamedContext)context)).isNull();
        }

        @Test
        void withValidValue() {
            NamedContext context = new NamedContext();
            context.setAdditionalProperty("KUBERNETES_CONFIG_CONTEXT_FILE_KEY", (Object)new File("."));
            Assertions.assertThat((File)KubeConfigUtils.getFileWithNamedContext((NamedContext)context)).isEqualTo((Object)new File("."));
        }
    }

    @Nested
    class PersistKubeConfigIntoFile {
        PersistKubeConfigIntoFile() {
        }

        @Test
        void writesTheKubeconfigIntoFile() throws IOException {
            Path file = KubeConfigUtilsTest.this.tempDir.resolve("kubeconfig");
            Config config = ((ConfigBuilder)new ConfigBuilder().withCurrentContext("selected-context")).build();
            KubeConfigUtils.persistKubeConfigIntoFile((Config)config, (File)file.toFile());
            ((AbstractStringAssert)Assertions.assertThat((Path)file).content().contains(new CharSequence[]{"---"})).contains(new CharSequence[]{"current-context: \"selected-context\""});
        }

        @Test
        void doesntPersistAdditionalProperties() throws IOException {
            File file = new File(Objects.requireNonNull(KubeConfigUtilsTest.class.getResource("/internal/kube-config-utils-parse/config-1.yaml")).getPath());
            Config config = KubeConfigUtils.parseConfig((File)file);
            ((NamedContext)config.getContexts().iterator().next()).getAdditionalProperties().put("KUBERNETES_CONFIG_CONTEXT_FILE_KEY", file);
            ((NamedCluster)config.getClusters().iterator().next()).getAdditionalProperties().put("KUBERNETES_CONFIG_CLUSTER_FILE_KEY", file);
            ((NamedAuthInfo)config.getUsers().iterator().next()).getAdditionalProperties().put("KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY", file);
            KubeConfigUtils.persistKubeConfigIntoFile((Config)config, (File)file);
            ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((File)file).content().doesNotContain(new CharSequence[]{"KUBERNETES_CONFIG_CONTEXT_FILE_KEY"})).doesNotContain(new CharSequence[]{"KUBERNETES_CONFIG_CLUSTER_FILE_KEY"})).doesNotContain(new CharSequence[]{"KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY"})).doesNotContain(new CharSequence[]{"KUBERNETES_CONFIG"});
        }
    }

    @Nested
    class ParseConfig {
        ParseConfig() {
        }

        @Test
        void throwsExceptionIfNullFile() {
            Assertions.assertThatExceptionOfType(KubernetesClientException.class).isThrownBy(() -> KubeConfigUtils.parseConfig(null)).withMessage("kubeconfig (File) cannot be null");
        }

        @Test
        void throwsExceptionIfInvalidFile() throws IOException {
            Path file = KubeConfigUtilsTest.this.tempDir.resolve("invalid-file");
            Files.writeString(file, (CharSequence)"invalid-yaml-content", StandardOpenOption.CREATE);
            Assertions.assertThatIllegalArgumentException().isThrownBy(() -> KubeConfigUtils.parseConfig((File)file.toFile())).withMessageContaining("Cannot construct instance of `io.fabric8.kubernetes.api.model.Config`");
        }

        @Test
        void addsNamedContextAdditionalPropertyWithFileLocation() {
            File file = new File(Objects.requireNonNull(KubeConfigUtilsTest.class.getResource("/internal/kube-config-utils-parse/config-1.yaml")).getPath());
            Config config = KubeConfigUtils.parseConfig((File)file);
            ((ObjectAssert)Assertions.assertThat((List)config.getContexts()).singleElement()).hasFieldOrPropertyWithValue("additionalProperties.KUBERNETES_CONFIG_CONTEXT_FILE_KEY", (Object)file);
        }

        @Test
        void addsNamedClusterAdditionalPropertyWithFileLocation() {
            File file = new File(Objects.requireNonNull(KubeConfigUtilsTest.class.getResource("/internal/kube-config-utils-parse/config-1.yaml")).getPath());
            Config config = KubeConfigUtils.parseConfig((File)file);
            ((ObjectAssert)Assertions.assertThat((List)config.getClusters()).singleElement()).hasFieldOrPropertyWithValue("additionalProperties.KUBERNETES_CONFIG_CLUSTER_FILE_KEY", (Object)file);
        }

        @Test
        void addsNamedAuthInfoAdditionalPropertyWithFileLocation() {
            File file = new File(Objects.requireNonNull(KubeConfigUtilsTest.class.getResource("/internal/kube-config-utils-parse/config-1.yaml")).getPath());
            Config config = KubeConfigUtils.parseConfig((File)file);
            ((ObjectAssert)Assertions.assertThat((List)config.getUsers()).singleElement()).hasFieldOrPropertyWithValue("additionalProperties.KUBERNETES_CONFIG_AUTH_INFO_FILE_KEY", (Object)file);
        }

        @Test
        void parsesConfiguration() {
            Config result = KubeConfigUtils.parseConfig((File)new File(Objects.requireNonNull(KubeConfigUtilsTest.class.getResource("/internal/kube-config-utils-parse/config-1.yaml")).getPath()));
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isNotNull()).hasFieldOrPropertyWithValue("currentContext", (Object)"selected-context")).returns((Object)1, c -> c.getClusters().size())).returns((Object)1, c -> c.getContexts().size())).returns((Object)1, c -> c.getUsers().size());
        }
    }
}

