/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.http.Headers;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpClientProxyTest {
    private static DefaultMockServer proxyServer;

    @BeforeAll
    static void beforeAll() {
        proxyServer = new DefaultMockServer(false);
        proxyServer.start();
    }

    @AfterAll
    static void afterAll() {
        proxyServer.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="Proxied HttpClient with basic authorization adds required headers to the request")
    protected void proxyConfigurationBasicAuthAddsRequiredHeaders() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)proxyServer.expect().get()).withPath("http://example.com/proxied")).andReply((ResponseProvider)new ResponseProvider<Object>(){

            public String getBody(RecordedRequest request) {
                return "\n";
            }

            public void setHeaders(Headers headers) {
            }

            public int getStatusCode(RecordedRequest request) {
                return request.getHeader("Proxy-Authorization") != null ? 200 : 407;
            }

            public Headers getHeaders() {
                return new Headers.Builder().add("Proxy-Authenticate", "Basic").build();
            }
        })).always();
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().proxyAddress(new InetSocketAddress("localhost", proxyServer.getPort())).proxyAuthorization(HttpClientUtils.basicCredentials((String)"auth", (String)"cred"));
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri("http://example.com/proxied").build(), String.class).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)proxyServer.getLastRequest()).extracting(RecordedRequest::getHeaders).returns((Object)"example.com", h -> h.get("Host")).returns((Object)"Basic YXV0aDpjcmVk", h -> h.get("Proxy-Authorization"));
        }
    }

    @Test
    @DisplayName(value="Proxied HttpClient with other authorization adds required headers to the request")
    protected void proxyConfigurationOtherAuthAddsRequiredHeaders() throws Exception {
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().proxyAddress(new InetSocketAddress("localhost", proxyServer.getPort())).proxyAuthorization("Other kind of auth");
        try (HttpClient client = builder.build();){
            client.sendAsync(client.newHttpRequestBuilder().uri("http://example.com/proxied").build(), String.class).get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)proxyServer.getLastRequest()).extracting(RecordedRequest::getHeaders).returns((Object)"example.com", h -> h.get("Host")).returns((Object)"Other kind of auth", h -> h.get("Proxy-Authorization"));
        }
    }
}

