/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class ConfigMapLockTest {
    private KubernetesClient kc;

    ConfigMapLockTest() {
    }

    @BeforeEach
    void setUp() {
        this.kc = (KubernetesClient)Mockito.mock(KubernetesClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    void missingNamespaceShouldThrowException() {
        Executable newInstance = () -> new ConfigMapLock(null, "name", "1337");
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingNameShouldThrowException() {
        Executable newInstance = () -> new ConfigMapLock("namespace", null, "1337");
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void missingIdentityShouldThrowException() {
        Executable newInstance = () -> new ConfigMapLock("namespace", "name", null);
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, (Executable)newInstance);
    }

    @Test
    void getWithExistingConfigMapShouldReturnLeaderElectionRecord() {
        ConfigMap cm = new ConfigMap();
        cm.setMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withAnnotations(Collections.singletonMap("control-plane.alpha.kubernetes.io/leader", "{\"holderIdentity\":\"1337\",\"leaseDuration\":15,\"acquireTime\":\"2015-10-21T04:29:00.000000Z\",\"renewTime\":\"2015-10-21T07:28:00.000000Z\"}"))).withResourceVersion("313373")).build());
        ConfigMapLock lock = new ConfigMapLock("namespace", "name", "1337");
        LeaderElectionRecord result = lock.toRecord(cm);
        ((AbstractZonedDateTimeAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).hasFieldOrPropertyWithValue("holderIdentity", (Object)"1337")).returns((Object)15L, ler -> ler.getLeaseDuration().getSeconds())).extracting(LeaderElectionRecord::getAcquireTime).asInstanceOf(InstanceOfAssertFactories.ZONED_DATE_TIME)).isEqualTo((Object)ZonedDateTime.of(2015, 10, 21, 4, 29, 0, 0, ZoneId.of("UTC")));
    }

    @Test
    void createWithValidLeaderElectionRecordShouldSendPostRequest() throws Exception {
        LeaderElectionRecord record = new LeaderElectionRecord("1", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        ConfigMapLock lock = new ConfigMapLock("namespace", "name", "1337");
        lock.create(this.kc, record);
        ((NamespaceableResource)Mockito.verify((Object)this.kc.resource((HasMetadata)((ConfigMap)ArgumentMatchers.any(ConfigMap.class))))).create();
    }

    @Test
    void updateWithValidLeaderElectionRecordShouldSendPatchRequest() throws Exception {
        LeaderElectionRecord record = new LeaderElectionRecord("1337", Duration.ofSeconds(1L), ZonedDateTime.now(), ZonedDateTime.now(), 0);
        ConfigMapLock lock = new ConfigMapLock("namespace", "name", "1337");
        ConfigMap configMap = lock.toResource(record, lock.getObjectMeta("313373"));
        lock.setResource((HasMetadata)configMap);
        lock.update(this.kc, record.toBuilder().leaseDuration(Duration.ofSeconds(2L)).build());
        ((NamespaceableResource)Mockito.verify((Object)this.kc.resource((HasMetadata)((ConfigMap)ArgumentMatchers.any(ConfigMap.class))))).patch((PatchContext)ArgumentMatchers.any(PatchContext.class));
    }

    @Test
    void identityShouldReturnProvidedIdentity() {
        ConfigMapLock configMapLock = new ConfigMapLock("namespace", "name", "1337");
        String identity = configMapLock.identity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1337", (Object)identity);
    }

    @Test
    void describeShouldReturnAnIdentifiableDescription() {
        ConfigMapLock configMapLock = new ConfigMapLock("namespace", "name", "1337");
        String description = configMapLock.describe();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ConfigMapLock: namespace - name (1337)", (Object)description);
    }
}

