/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.lib.FileSystem;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

class ConfigTest {
    private static final String TEST_KUBECONFIG_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig"));
    private static final String TEST_EC_KUBECONFIG_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-ec-kubeconfig"));
    private static final String TEST_NAMESPACE_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-namespace"));
    private static final String TEST_KUBECONFIG_EXEC_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec"));
    private static final String TEST_TOKEN_GENERATOR_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/token-generator"));
    private static final String TEST_TOKEN_GENERATOR_FILE_WITH_SPACES = Utils.filePath((URL)ConfigTest.class.getResource("/token-generator with spaces"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-null-args"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-null-args"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES_WIN = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-with-spaces-windows"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-with-spaces"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES_WIN = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-args-with-spaces-windows"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-args-with-spaces"));
    private static final String TEST_KUBECONFIG_NO_CURRENT_CONTEXT_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-nocurrentctxt"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-cert-auth"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-cert-auth"));
    private static final String TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH_EC_INVALID = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-cert-auth-ec-invalid"));
    private static final String TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH_EC_INVALID = Utils.filePath((URL)ConfigTest.class.getResource("/test-kubeconfig-exec-win-cert-auth-ec-invalid"));
    private static final String TEST_CERT_GENERATOR_FILE = Utils.filePath((URL)ConfigTest.class.getResource("/cert-generator"));

    ConfigTest() {
    }

    @Test
    @DisplayName(value="when fields configured via builder, then fields get most precedence")
    void builder_whenInvoked_shouldCreateConfigWithConfiguredFields() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withApiVersion("v1")).withNamespace("testns")).withOauthToken("token")).withUsername("user")).withPassword("pass")).withTrustCerts(true)).withDisableHostnameVerification(true)).withCaCertFile("/path/to/cert")).withCaCertData("cacertdata")).withClientCertFile("/path/to/clientcert")).withClientCertData("clientcertdata")).withClientKeyFile("/path/to/clientkey")).withClientKeyData("clientkeydata")).withClientKeyAlgo("algo")).withClientKeyPassphrase("passphrase")).withMaxConcurrentRequests(120)).withMaxConcurrentRequestsPerHost(Integer.valueOf(20))).withWatchReconnectInterval(5000)).withWatchReconnectLimit(5)).withRequestTimeout(5000)).withUploadRequestTimeout(600000)).withHttpProxy("httpProxy")).withHttpsProxy("httpsProxy")).withProxyUsername("proxyUsername")).withProxyPassword("proxyPassword")).withNoProxy(new String[]{"no-proxy-url1.io", "no-proxy-url2.io"})).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).withTrustStoreFile("/path/to/truststore")).withTrustStorePassphrase("truststorePassphrase")).withKeyStoreFile("/path/to/keystore")).withKeyStorePassphrase("keystorePassphrase")).withHttp2Disable(false)).withWebsocketPingInterval(1000L)).withConnectionTimeout(1000)).withScaleTimeout(1000L)).build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("username", (Object)"user")).hasFieldOrPropertyWithValue("password", (Object)"pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"no-proxy-url1.io", "no-proxy-url2.io"})).hasFieldOrPropertyWithValue("oauthToken", (Object)"token");
    }

    @Test
    @DisplayName(value="no additional config, should use default value for webSocketPingInterval")
    void builder_whenInvoked_shouldHonorDefaultWebsocketPingInterval() {
        Config config = new ConfigBuilder().build();
        Assertions.assertThat((Long)config.getWebsocketPingInterval()).isEqualTo(30000L);
    }

    @Test
    @DisplayName(value="when multiple kube config files in property, then pick first one")
    void autoConfigure_withMultipleKubeConfigAndOverrideContext_shouldPickFirstFile() {
        try {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE + File.pathSeparator + "some-other-file");
            Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/root");
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"production")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"supertoken")).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator))})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()});
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="when kubenamespace file property provided, then read namespace from this file")
    void whenNamespacePathFilePropertyConfigured_shouldUpdateNamespace() {
        try {
            System.setProperty("kubeconfig", "no-kubeconfig-file");
            System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
            System.setProperty("kubernetes.master", "http://somehost:80");
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testnsfrompath");
        }
        finally {
            System.clearProperty("kubeconfig");
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
        }
    }

    @Test
    @DisplayName(value="kubenamespace property configured with non existent file, then do NOT update Config's namespace")
    void whenNamespacePathFilePropertyConfiguredWithNonExistentFile_shouldNotUpdateNamespace() {
        try {
            System.setProperty("kubeconfig", "no-kubeconfig-file");
            System.setProperty("kubenamespace", "nonamespace");
            System.setProperty("kubernetes.master", "http://somehost:80");
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", null);
        }
        finally {
            System.clearProperty("kubeconfig");
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
        }
    }

    @Test
    @DisplayName(value="kubenamespace property and kubernetes.namespace property provided, then kubernetes.namespace takes precedence")
    void whenNamespacePathFilePropertyAndNamespacePropertyProvided_thenNamespacePropertyTakesPrecedence() {
        try {
            System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
            System.setProperty("kubernetes.master", "http://somehost:80");
            System.setProperty("kubernetes.namespace", "testns");
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns");
        }
        finally {
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
        }
    }

    @Test
    @DisplayName(value="no currentContext set in kubeconfig, then do NOT set currentContext in kubeconfig")
    void whenNoCurrentContextInKubeConfig_thenDoNotSetCurrentContext() {
        try {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_NO_CURRENT_CONTEXT_FILE);
            Config config = new ConfigBuilder().build();
            ((ListAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("currentContext", null)).hasFieldOrPropertyWithValue("namespace", null)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).extracting(Config::getContexts).asInstanceOf(InstanceOfAssertFactories.list(NamedContext.class))).hasSize(3);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="kubenamespace, kubernetes.namespace and ConfigBuilder.withNamespace provided, ConfigBuilder.withNamespace takes precedence")
    void whenNamespacePathAndSystemPropertiesAndBuilderProvided_thenBuilderTakesPrecedence() {
        try {
            System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
            System.setProperty("kubernetes.master", "http://somehost:80");
            System.setProperty("kubernetes.namespace", "tobeoverriden");
            Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns2");
        }
        finally {
            System.clearProperty("kubenamespace");
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
        }
    }

    @Test
    @DisplayName(value="customHeaders configured via builder, then set customHeaders in Config")
    void whenCustomHeaderProvidedViaBuilder_thenSetCustomHeaderInConfig() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("user-id", "test-user");
        customHeaders.put("cluster-id", "test-cluster");
        Config config = ((ConfigBuilder)new ConfigBuilder().withCustomHeaders(customHeaders)).build();
        ((MapAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).extracting(Config::getCustomHeaders).asInstanceOf(InstanceOfAssertFactories.MAP)).hasSize(2);
    }

    @Test
    @DisplayName(value="when impersonate-username, impersonate-extras configured via System Properties and ConfigBuilder, then ConfigBuilder takes precedence")
    void shouldSetImpersonateUsernameAndGroupFromSystemProperty() {
        try {
            System.setProperty("kubernetes.impersonate.username", "username");
            System.setProperty("kubernetes.impersonate.group", "group");
            HashMap<String, List<String>> extras = new HashMap<String, List<String>>();
            extras.put("c", Collections.singletonList("d"));
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withImpersonateUsername("a")).withImpersonateExtras(extras)).build();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("requestConfig.impersonateUsername", (Object)"a")).hasFieldOrPropertyWithValue("requestConfig.impersonateGroups", (Object)new String[]{"group"})).hasFieldOrPropertyWithValue("requestConfig.impersonateExtras", Collections.singletonMap("c", Collections.singletonList("d")));
        }
        finally {
            System.clearProperty("kubernetes.impersonate.username");
            System.clearProperty("kubernetes.impersonate.group");
        }
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    void honorClientAuthenticatorCommandsOnWindows() {
        try {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE);
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO WORLD");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void honorClientAuthenticatorCommands() throws Exception {
        try {
            Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
            System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE);
            Config config = new ConfigBuilder().build();
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO WORLD");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void should_accept_client_authentication_commands_with_null_args() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WIN_NULL_ARGS);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_NULL_ARGS);
            }
            Config config = Config.autoConfigure(null);
            Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="when arguments in kubeconfig, then add client cert data to Config")
    void autoConfigure_whenCommandLineArgsProvided_thenLoadClientCertData() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_CERT_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("clientCertData", (Object)"CERT DATA")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"KEY DATA");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="when invalid arguments in kubeconfig, then do not add client cert data to Config")
    void autoConfigure_whenInvalidArgsProvided_thenDoNotLoadClientCertData() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_WIN_FILE_CERT_AUTH_EC_INVALID);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_CERT_GENERATOR_FILE, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_CERT_AUTH_EC_INVALID);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("clientCertData", null)).hasFieldOrPropertyWithValue("clientKeyData", null);
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void should_accept_client_authentication_commands_args_with_spaces() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES_WIN);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE_WITH_SPACES, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_ARGS_WITH_SPACES);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO W O R L D");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void should_accept_client_authentication_commands_with_spaces() throws Exception {
        try {
            if (FileSystem.getCurrent() == FileSystem.WINDOWS) {
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES_WIN);
            } else {
                Files.setPosixFilePermissions(Paths.get(TEST_TOKEN_GENERATOR_FILE_WITH_SPACES, new String[0]), PosixFilePermissions.fromString("rwxrwxr-x"));
                System.setProperty("kubeconfig", TEST_KUBECONFIG_EXEC_FILE_WITH_SPACES);
            }
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"HELLO WORLD");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    void shouldBeUsedTokenSuppliedByProvider() {
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withOauthToken("oauthToken")).withOauthTokenProvider(() -> "PROVIDER_TOKEN")).build();
        Assertions.assertThat((String)config.getOauthToken()).isEqualTo("oauthToken");
    }

    @Test
    @DisplayName(value="kubeconfig contains auth-provider, then read token from auth-provider section")
    void whenKubeConfigWithAuthConfigProvider_thenLoadTokenFromAuthProvider() throws URISyntaxException {
        try {
            System.setProperty("kubeconfig", new File(this.getClass().getResource("/test-kubeconfig").toURI()).getAbsolutePath());
            Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/mmosley");
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"eyJraWQiOiJDTj1vaWRjaWRwLnRyZW1vbG8ubGFuLCBPVT1EZW1vLCBPPVRybWVvbG8gU2VjdXJpdHksIEw9QXJsaW5ndG9uLCBTVD1WaXJnaW5pYSwgQz1VUy1DTj1rdWJlLWNhLTEyMDIxNDc5MjEwMzYwNzMyMTUyIiwiYWxnIjoiUlMyNTYifQ.eyJpc3MiOiJodHRwczovL29pZGNpZHAudHJlbW9sby5sYW46ODQ0My9hdXRoL2lkcC9PaWRjSWRQIiwiYXVkIjoia3ViZXJuZXRlcyIsImV4cCI6MTQ4MzU0OTUxMSwianRpIjoiMm96US15TXdFcHV4WDlHZUhQdy1hZyIsImlhdCI6MTQ4MzU0OTQ1MSwibmJmIjoxNDgzNTQ5MzMxLCJzdWIiOiI0YWViMzdiYS1iNjQ1LTQ4ZmQtYWIzMC0xYTAxZWU0MWUyMTgifQ.w6p4J_6qQ1HzTG9nrEOrubxIMb9K5hzcMPxc9IxPx2K4xO9l-oFiUw93daH3m5pluP6K7eOE6txBuRVfEcpJSwlelsOsW8gb8VJcnzMS9EnZpeA0tW_p-mnkFc3VcfyXuhe5R3G7aa5d8uHv70yJ9Y3-UhjiN9EhpMdfPAoEB9fYKKkJRzF7utTTIPGrSaSU6d2pcpfYKaxIwePzEkT4DfcQthoZdy9ucNvvLoi1DIC-UocFD8HLs8LYKEqSxQvOcvnThbObJ9af71EwmuE21fO5KzMW20KtAeget1gnldOosPtz1G5EwvaQ401-RPQzPGMVBld0_zMCAwZttJ4knw");
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Test
    @DisplayName(value="Config.empty() should create an empty non auto-configured instance with default values")
    void emptyConfig() {
        Config emptyConfig = Config.empty();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)emptyConfig).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isNotNull()});
    }

    @Test
    void refresh_whenOAuthTokenSourceSetToUser_thenConfigUnchanged() {
        Config config = ((ConfigBuilder)new ConfigBuilder().withOauthToken("token-from-user")).build();
        Config updatedConfig = config.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)updatedConfig).isSameAs((Object)config)).hasFieldOrPropertyWithValue("oauthToken", (Object)"token-from-user");
    }

    @Test
    void givenEmptyKubeConfig_whenConfigCreated_thenShouldNotProduceNPE() throws URISyntaxException {
        try {
            System.setProperty("kubeconfig", new File(Objects.requireNonNull(this.getClass().getResource("/test-empty-kubeconfig")).toURI()).getAbsolutePath());
            Config config = new ConfigBuilder().build();
            Assertions.assertThat((Object)config).isNotNull();
        }
        finally {
            System.clearProperty("kubeconfig");
        }
    }

    @Nested
    @DisplayName(value="Config.getHomeDir")
    class GetHomeDir {
        GetHomeDir() {
        }

        @Test
        @EnabledOnOs(value={OS.WINDOWS})
        void shouldUseHomeEnvVariable_WhenEnabledOnWindows_WhenHomeEnvVariableIsSet() {
            HashMap<String, String> envVars = new HashMap<String, String>();
            envVars.put("HOMEDRIVE", "C:\\Users\\");
            envVars.put("HOMEPATH", "user");
            envVars.put("HOME", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
            Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
        }

        @Test
        void shouldReturnUserHomeProp_WhenHomeEnvVariablesAreNotSet() {
            String userHomePropToRestore = System.getProperty("user.home");
            try {
                System.setProperty("user.home", "/home/user");
                Map emptyEnvVars = Collections.emptyMap();
                Assertions.assertThat((String)Config.getHomeDir(f -> true, emptyEnvVars::get)).isEqualTo("/home/user");
            }
            finally {
                System.setProperty("user.home", userHomePropToRestore);
            }
        }

        @Nested
        @DisplayName(value="os.name=Windows")
        class OsNameWindows {
            private String osNamePropToRestore;

            OsNameWindows() {
            }

            @BeforeEach
            void setUp() {
                this.osNamePropToRestore = System.getProperty("os.name");
                System.setProperty("os.name", "Windows");
            }

            @AfterEach
            void tearDown() {
                System.setProperty("os.name", this.osNamePropToRestore);
            }

            @Test
            void shouldUseHomeDriveHomePathOnWindows_WhenHomeEnvVariableIsNotSet() {
                HashMap<String, String> envVars = new HashMap<String, String>();
                envVars.put("HOMEDRIVE", "C:\\Users\\");
                envVars.put("HOMEPATH", "user");
                envVars.put("USERPROFILE", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
                Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user");
            }

            @Test
            void shouldUseUserprofileOnWindows_WhenHomeHomeDriveHomePathEnvVariablesAreNotSet() {
                HashMap<String, String> envVars = new HashMap<String, String>();
                envVars.put("USERPROFILE", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
                Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
            }

            @Test
            void shouldUseHomeEnvVariableOnWindows_WhenHomeEnvVariableIsSet() {
                HashMap<String, String> envVars = new HashMap<String, String>();
                envVars.put("HOMEDRIVE", "C:\\Users\\");
                envVars.put("HOMEPATH", "user");
                envVars.put("HOME", "C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
                Assertions.assertThat((String)Config.getHomeDir(f -> true, envVars::get)).isEqualTo("C:\\Users\\user\\workspace\\myworkspace\\tools\\cygwin\\");
            }
        }
    }

    @Nested
    @DisplayName(value="load fromKubeConfig")
    class FromKubeConfig {
        FromKubeConfig() {
        }

        @BeforeEach
        void setUp() {
            System.clearProperty("kubeconfig");
            System.clearProperty("kubernetes.master");
        }

        @Test
        @DisplayName(value="standard kubeconfig file")
        void fromKubeConfigContent() throws IOException {
            Config config = Config.fromKubeconfig((String)this.prepareKubeConfigYamlFrom(TEST_KUBECONFIG_FILE));
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("file", null)).isSameAs((Object)config.refresh());
        }

        @Test
        @DisplayName(value="kubeconfig with EC Private Data in client key")
        void shouldAutoDetectClientKeyAlgo() throws IOException {
            Config config = Config.fromKubeconfig((String)this.prepareKubeConfigYamlFrom(TEST_EC_KUBECONFIG_FILE));
            Assertions.assertThat((String)config.getClientKeyAlgo()).isEqualTo("EC");
        }

        private String prepareKubeConfigYamlFrom(String filePath) throws IOException {
            File configFile = new File(filePath);
            return String.join((CharSequence)System.lineSeparator(), Files.readAllLines(configFile.toPath()));
        }
    }

    @Nested
    @DisplayName(value="kubeconfig present")
    class KubeConfigPresent {
        KubeConfigPresent() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
            System.clearProperty("kubernetes.namespace");
        }

        @Test
        @DisplayName(value="default config should auto configure from kubeconfig")
        void defaultConfig_shouldAutoConfigureFromKubeConfig() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new ConfigBuilder().build()).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token")).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator))})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()})).hasFieldOrPropertyWithValue("file", (Object)new File(TEST_KUBECONFIG_FILE));
        }

        @Test
        @DisplayName(value="Config.autoConfigure with overridden context")
        void overrideContext() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)Config.autoConfigure((String)"production/172-28-128-4:8443/root")).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("namespace", (Object)"production")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"supertoken")).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator))})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()});
        }
    }

    @Nested
    @DisplayName(value="Inside Kubernetes cluster")
    class InCluster {
        InCluster() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", "/dev/null");
            System.clearProperty("kubernetes.master");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubeconfig");
        }

        @Test
        @DisplayName(value="when KUBERNETES_SERVICE_HOST,KUBERNETES_SERVICE_PORT env variables present, then compute masterUrl from environment variables")
        void autoConfigure_whenKubernetesServiceEnvironmentVariablesPresent_thenComputeMasterUrlFromEnvironmentVariables() {
            try {
                System.setProperty("KUBERNETES_SERVICE_HOST", "10.0.0.1");
                System.setProperty("KUBERNETES_SERVICE_PORT", "443");
                Config config = Config.autoConfigure(null);
                ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://10.0.0.1:443/")).hasFieldOrPropertyWithValue("file", null);
            }
            finally {
                System.clearProperty("KUBERNETES_SERVICE_HOST");
                System.clearProperty("KUBERNETES_SERVICE_PORT");
            }
        }

        @Test
        @DisplayName(value="refresh() creates new instance when invoked")
        void refresh_whenInvoked_shouldCreateNewInstance() {
            Config config = Config.autoConfigure(null);
            ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("file", null)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true);
            Config refresh = config.refresh();
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)refresh).isNotSameAs((Object)config)).hasFieldOrPropertyWithValue("file", null)).hasFieldOrPropertyWithValue("autoConfigure", (Object)true);
        }

        @Test
        @DisplayName(value="when KUBERNETES_SERVICE_HOST,KUBERNETES_SERVICE_PORT env variables present with IPv6 address, then compute masterUrl from environment variables")
        void autoConfigure_whenKubernetesServiceEnvironmentVariablesPresentWithIPv6_thenComputeMasterUrlFromEnvironmentVariables() {
            try {
                System.setProperty("KUBERNETES_SERVICE_HOST", "2001:db8:1f70::999:de8:7648:6e8");
                System.setProperty("KUBERNETES_SERVICE_PORT", "443");
                Config config = Config.autoConfigure(null);
                ((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://[2001:db8:1f70::999:de8:7648:6e8]:443/")).hasFieldOrPropertyWithValue("file", null);
            }
            finally {
                System.clearProperty("KUBERNETES_SERVICE_HOST");
                System.clearProperty("KUBERNETES_SERVICE_PORT");
            }
        }

        @Test
        @DisplayName(value="when ServiceAccount token file provided, then use it as autoOAuthToken")
        void whenServiceAccountTokenPathProvided_thenUseThatToken() {
            try {
                System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigTest.class.getResource("/test-serviceaccount/token")));
                Config config = new ConfigBuilder().build();
                Assertions.assertThat((String)config.getAutoOAuthToken()).contains(new CharSequence[]{"token-from-mounted-serviceaccount"});
            }
            finally {
                System.clearProperty("kubernetes.auth.serviceAccount.token");
            }
        }

        @Test
        @DisplayName(value="when ServiceAccount certificate file provided, then use it as caCertFile")
        void whenServiceAccountCertFilePathProvided_thenUseThatToken() {
            try {
                String certFilePath = Utils.filePath((URL)ConfigTest.class.getResource("/test-serviceaccount/ca.crt"));
                System.setProperty("kubernetes.certs.ca.file", certFilePath);
                Config config = new ConfigBuilder().build();
                Assertions.assertThat((String)config.getCaCertFile()).isEqualTo(certFilePath);
            }
            finally {
                System.clearProperty("kubernetes.certs.ca.file");
            }
        }

        @Test
        @DisplayName(value="when kubernetes.tryNamespacePath=false, then do NOT read ServiceAccount files")
        void whenTryNamespacePathDisabled_thenDoNotUseServiceAccountAttributes() {
            try {
                System.setProperty("kubernetes.auth.tryServiceAccount", "false");
                System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigTest.class.getResource("/test-serviceaccount/token")));
                Config config = new ConfigBuilder().build();
                Assertions.assertThat((String)config.getAutoOAuthToken()).isNull();
            }
            finally {
                System.clearProperty("kubernetes.auth.tryServiceAccount");
                System.clearProperty("kubernetes.auth.serviceAccount.token");
            }
        }
    }

    @Nested
    @DisplayName(value="System Properties Configured")
    class SystemPropertiesConfigured {
        SystemPropertiesConfigured() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubernetes.master", "http://somehost:80");
            System.setProperty("kubernetes.namespace", "testns");
            System.setProperty("kubernetes.auth.token", "token");
            System.setProperty("kubernetes.auth.basic.username", "user");
            System.setProperty("kubernetes.auth.basic.password", "pass");
            System.setProperty("kubernetes.trust.certificates", "true");
            System.setProperty("kubernetes.disable.hostname.verification", "true");
            System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
            System.setProperty("kubernetes.certs.ca.data", "cacertdata");
            System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
            System.setProperty("kubernetes.certs.client.data", "clientcertdata");
            System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
            System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
            System.setProperty("kubernetes.certs.client.key.algo", "algo");
            System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
            System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
            System.setProperty("kubernetes.max.concurrent.requests", "120");
            System.setProperty("kubernetes.max.concurrent.requests.per.host", "20");
            System.setProperty("kubernetes.watch.reconnectInterval", "5000");
            System.setProperty("kubernetes.watch.reconnectLimit", "5");
            System.setProperty("kubernetes.request.timeout", "5000");
            System.setProperty("http.proxy", "httpProxy");
            System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
            System.setProperty("kubernetes.truststore.file", "/path/to/truststore");
            System.setProperty("kubernetes.truststore.passphrase", "truststorePassphrase");
            System.setProperty("kubernetes.keystore.file", "/path/to/keystore");
            System.setProperty("kubernetes.keystore.passphrase", "keystorePassphrase");
            System.setProperty("kubernetes.upload.request.timeout", "600000");
            System.setProperty("kubernetes.websocket.ping.interval", "1000");
            System.setProperty("kubernetes.connection.timeout", "1000");
            System.setProperty("kubernetes.scale.timeout", "1000");
            System.setProperty("https.proxy", "httpsProxy");
            System.setProperty("no.proxy", "no-proxy-url1.io,no-proxy-url2.io");
            System.setProperty("proxy.username", "proxyUsername");
            System.setProperty("proxy.password", "proxyPassword");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
            System.clearProperty("kubernetes.auth.token");
            System.clearProperty("kubernetes.auth.basic.username");
            System.clearProperty("kubernetes.auth.basic.password");
            System.clearProperty("kubernetes.trust.certificates");
            System.clearProperty("kubernetes.disable.hostname.verification");
            System.clearProperty("kubernetes.certs.ca.file");
            System.clearProperty("kubernetes.certs.ca.data");
            System.clearProperty("kubernetes.certs.client.file");
            System.clearProperty("kubernetes.certs.client.data");
            System.clearProperty("kubernetes.certs.client.key.file");
            System.clearProperty("kubernetes.certs.client.key.data");
            System.clearProperty("kubernetes.certs.client.key.algo");
            System.clearProperty("kubernetes.certs.client.key.passphrase");
            System.clearProperty("kubernetes.certs.client.key.file");
            System.clearProperty("kubernetes.max.concurrent.requests");
            System.clearProperty("kubernetes.max.concurrent.requests.per.host");
            System.clearProperty("kubernetes.watch.reconnectInterval");
            System.clearProperty("kubernetes.watch.reconnectLimit");
            System.clearProperty("kubernetes.request.timeout");
            System.clearProperty("http.proxy");
            System.clearProperty("kubernetes.tls.versions");
            System.clearProperty("kubernetes.truststore.file");
            System.clearProperty("kubernetes.truststore.passphrase");
            System.clearProperty("kubernetes.keystore.file");
            System.clearProperty("kubernetes.keystore.passphrase");
            System.clearProperty("kubernetes.upload.request.timeout");
            System.clearProperty("kubernetes.websocket.ping.interval");
            System.clearProperty("kubernetes.connection.timeout");
            System.clearProperty("kubernetes.scale.timeout");
            System.clearProperty("https.proxy");
            System.clearProperty("no.proxy");
            System.clearProperty("proxy.username");
            System.clearProperty("proxy.password");
        }

        @Test
        @DisplayName(value="default config, should load from properties")
        void defaultConfig_whenInvoked_shouldLoadFromProperties() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new ConfigBuilder().build()).isNotNull()).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("username", (Object)"user")).hasFieldOrPropertyWithValue("password", (Object)"pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"no-proxy-url1.io", "no-proxy-url2.io"})).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token");
        }

        @Test
        @DisplayName(value="ConfigBuilder, should load from properties")
        void configBuilder_whenInvoked_shouldLoadFromProperties() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new ConfigBuilder().build()).isNotNull()).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("username", (Object)"user")).hasFieldOrPropertyWithValue("password", (Object)"pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"no-proxy-url1.io", "no-proxy-url2.io"})).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token");
        }

        @Test
        @DisplayName(value="ConfigBuilder, with builder methods, should override properties")
        void configBuilder_withBuilderMethods_shouldOverrideFieldsConfiguredViaProperties() {
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost-via-builder:80")).withNamespace("testns-via-builder")).build();
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://somehost-via-builder:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"testns-via-builder")).hasFieldOrPropertyWithValue("username", (Object)"user")).hasFieldOrPropertyWithValue("password", (Object)"pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"no-proxy-url1.io", "no-proxy-url2.io"})).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token");
        }
    }
}

