/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class ConfigDisableAutoConfigurationTest {
    private final NamedContext userConfiguredNamedContext = ((NamedContextBuilder)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextBuilder)new NamedContextBuilder().withName("context1")).withNewContext().withCluster("api-test-openshiftapps-com:6443")).withUser("testuser/api-test-openshiftapps-com:6443")).endContext()).build();

    ConfigDisableAutoConfigurationTest() {
    }

    @Nested
    @DisplayName(value="With autoConfigure(false) in ConfigBuilder")
    class AutoConfigDisabledViaBuilder {
        private ConfigBuilder configBuilder;

        AutoConfigDisabledViaBuilder() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubeconfig", "/dev/null");
            this.configBuilder = (ConfigBuilder)new ConfigBuilder().withAutoConfigure(false);
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubeconfig");
        }

        @Nested
        @DisplayName(value="And kubeconfig present")
        class KubeConfigPresent {
            KubeConfigPresent() {
            }

            @BeforeEach
            void setUp() throws IOException {
                System.setProperty("kubeconfig", Utils.filePath((URL)this.getClass().getResource("/config-disable-autoconfiguration/kube-config")));
            }

            @Test
            @DisplayName(value="then use default values")
            void whenConfigDisabledViaPropertyAndUserProvidesNoConfiguration_thenUseConfigDefaultValues() {
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)AutoConfigDisabledViaBuilder.this.configBuilder.build()).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isNotNull()});
            }

            @Test
            @DisplayName(value="And user configuration via builder, then user configuration via builder takes precedence")
            void whenConfigDisabledViaPropertyAndUserProvidesConfigurationViaConfigBuilder_thenUseConfigDefaultValues() {
                Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)AutoConfigDisabledViaBuilder.this.configBuilder.withMasterUrl("https://api-test.openshiftapps.com:6443")).withContexts(new NamedContext[]{ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withMaxConcurrentRequests(30)).withMaxConcurrentRequestsPerHost(Integer.valueOf(10))).withTrustCerts()).withDisableHostnameVerification()).withClientKeyAlgo("EC")).withWatchReconnectInterval(500)).withWatchReconnectLimit(10)).withConnectionTimeout(1000)).withRequestTimeout(1000)).withScaleTimeout(1000L)).withLoggingInterval(1000)).withWebsocketPingInterval(10000L)).withUploadRequestTimeout(1000)).withImpersonateExtras(Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).withHttp2Disable(true)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withImpersonateGroups(new String[]{"developer", "admin"})).withUserAgent("custom-user-agent")).build();
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api-test.openshiftapps.com:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.singletonList(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext))).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)30)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)10)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)1000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).hasFieldOrPropertyWithValue("http2Disable", (Object)true)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isEqualTo((Object)ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developer", "admin"})})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("custom-user-agent")});
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubeconfig");
            }
        }

        @Nested
        @DisplayName(value="And system properties configured")
        class SystemPropertiesConfigured {
            SystemPropertiesConfigured() {
            }

            @BeforeEach
            void setUp() {
                System.setProperty("kubernetes.master", "http://somehost:80");
                System.setProperty("kubernetes.namespace", "testns");
            }

            @Test
            @DisplayName(value="then use default values")
            void whenConfigDisabledViaPropertyAndUserProvidesNoConfiguration_thenUseConfigDefaultValues() {
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)AutoConfigDisabledViaBuilder.this.configBuilder.build()).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isNotNull()});
            }

            @Test
            @DisplayName(value="And user configuration via builder, then user configuration takes precedence")
            void whenConfigDisabledViaPropertyAndUserProvidesConfigurationViaConfigBuilder_thenUseConfigDefaultValues() {
                Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)AutoConfigDisabledViaBuilder.this.configBuilder.withMasterUrl("https://api-test.openshiftapps.com:6443")).withContexts(new NamedContext[]{ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withMaxConcurrentRequests(30)).withMaxConcurrentRequestsPerHost(Integer.valueOf(10))).withTrustCerts()).withDisableHostnameVerification()).withClientKeyAlgo("EC")).withWatchReconnectInterval(500)).withWatchReconnectLimit(10)).withConnectionTimeout(1000)).withRequestTimeout(1000)).withScaleTimeout(1000L)).withLoggingInterval(1000)).withWebsocketPingInterval(10000L)).withUploadRequestTimeout(1000)).withImpersonateExtras(Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).withHttp2Disable(true)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withImpersonateGroups(new String[]{"developer", "admin"})).withUserAgent("custom-user-agent")).build();
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api-test.openshiftapps.com:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.singletonList(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext))).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)30)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)10)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)1000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).hasFieldOrPropertyWithValue("http2Disable", (Object)true)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isEqualTo((Object)ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developer", "admin"})})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("custom-user-agent")});
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubernetes.master");
                System.clearProperty("kubeconfig");
                System.clearProperty("kubernetes.namespace");
            }
        }
    }

    @Nested
    @DisplayName(value="via kubernetes.disable.autoConfig=true")
    class AutoConfigDisabledViaProperty {
        AutoConfigDisabledViaProperty() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubernetes.disable.autoConfig", "true");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubernetes.disable.autoConfig");
        }

        @Nested
        @DisplayName(value="And kubeconfig present")
        class KubeConfigPresent {
            KubeConfigPresent() {
            }

            @BeforeEach
            void setUp() {
                System.setProperty("kubeconfig", Utils.filePath((URL)this.getClass().getResource("/config-disable-autoconfiguration/kube-config")));
            }

            @Test
            @DisplayName(value="then use default values")
            void whenConfigDisabledViaPropertyAndUserProvidesNoConfiguration_thenUseConfigDefaultValues() {
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isNotNull()});
            }

            @Test
            @DisplayName(value="And user configuration via builder, then user configuration via builder takes precedence")
            void whenConfigDisabledViaPropertyAndUserProvidesConfigurationViaConfigBuilder_thenUseConfigDefaultValues() {
                Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://api-test.openshiftapps.com:6443")).withContexts(new NamedContext[]{ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withMaxConcurrentRequests(30)).withMaxConcurrentRequestsPerHost(Integer.valueOf(10))).withTrustCerts()).withDisableHostnameVerification()).withClientKeyAlgo("EC")).withWatchReconnectInterval(500)).withWatchReconnectLimit(10)).withConnectionTimeout(1000)).withRequestTimeout(1000)).withScaleTimeout(1000L)).withLoggingInterval(1000)).withWebsocketPingInterval(10000L)).withUploadRequestTimeout(1000)).withImpersonateExtras(Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).withHttp2Disable(true)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withImpersonateGroups(new String[]{"developer", "admin"})).withUserAgent("custom-user-agent")).build();
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api-test.openshiftapps.com:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.singletonList(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext))).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)30)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)10)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)1000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).hasFieldOrPropertyWithValue("http2Disable", (Object)true)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isEqualTo((Object)ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developer", "admin"})})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("custom-user-agent")});
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubeconfig");
            }
        }

        @Nested
        @DisplayName(value="And system properties configured")
        class SystemPropertiesConfigured {
            SystemPropertiesConfigured() {
            }

            @BeforeEach
            void setUp() {
                System.setProperty("kubernetes.master", "http://somehost:80");
                System.setProperty("kubernetes.namespace", "testns");
            }

            @Test
            @DisplayName(value="then use default values")
            void whenConfigDisabledViaPropertyAndUserProvidesNoConfiguration_thenUseConfigDefaultValues() {
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isNotNull()});
            }

            @Test
            @DisplayName(value="And user configuration via builder, then user configuration takes precedence")
            void whenConfigDisabledViaPropertyAndUserProvidesConfigurationViaConfigBuilder_thenUseConfigDefaultValues() {
                Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://api-test.openshiftapps.com:6443")).withContexts(new NamedContext[]{ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withMaxConcurrentRequests(30)).withMaxConcurrentRequestsPerHost(Integer.valueOf(10))).withTrustCerts()).withDisableHostnameVerification()).withClientKeyAlgo("EC")).withWatchReconnectInterval(500)).withWatchReconnectLimit(10)).withConnectionTimeout(1000)).withRequestTimeout(1000)).withScaleTimeout(1000L)).withLoggingInterval(1000)).withWebsocketPingInterval(10000L)).withUploadRequestTimeout(1000)).withImpersonateExtras(Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).withHttp2Disable(true)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withImpersonateGroups(new String[]{"developer", "admin"})).withUserAgent("custom-user-agent")).build();
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api-test.openshiftapps.com:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.singletonList(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext))).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)30)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)10)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)1000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).hasFieldOrPropertyWithValue("http2Disable", (Object)true)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isEqualTo((Object)ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developer", "admin"})})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("custom-user-agent")});
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubernetes.master");
            }
        }

        @Nested
        @DisplayName(value="And inside Kubernetes Cluster with ServiceAccount mounted")
        class InsideKubernetesClusterWithMountedServiceAccount {
            InsideKubernetesClusterWithMountedServiceAccount() {
            }

            @BeforeEach
            void setUp() {
                System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigDisableAutoConfigurationTest.class.getResource("/config-disable-autoconfiguration/serviceaccount/token")));
                System.setProperty("kubenamespace", Utils.filePath((URL)ConfigDisableAutoConfigurationTest.class.getResource("/config-disable-autoconfiguration/serviceaccount/namespace")));
            }

            @Test
            @DisplayName(value="then use default values")
            void whenConfigDisabledViaPropertyAndUserProvidesNoConfiguration_thenUseConfigDefaultValues() {
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("contexts", Collections.emptyList())).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)20000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.emptyMap())).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isNull()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).isEmpty()})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isNotNull()});
            }

            @Test
            @DisplayName(value="And user configuration via builder, then user configuration takes precedence")
            void whenConfigDisabledViaPropertyAndUserProvidesConfigurationViaConfigBuilder_thenUseConfigDefaultValues() {
                Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://api-test.openshiftapps.com:6443")).withContexts(new NamedContext[]{ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withMaxConcurrentRequests(30)).withMaxConcurrentRequestsPerHost(Integer.valueOf(10))).withTrustCerts()).withDisableHostnameVerification()).withClientKeyAlgo("EC")).withWatchReconnectInterval(500)).withWatchReconnectLimit(10)).withConnectionTimeout(1000)).withRequestTimeout(1000)).withScaleTimeout(1000L)).withLoggingInterval(1000)).withWebsocketPingInterval(10000L)).withUploadRequestTimeout(1000)).withImpersonateExtras(Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).withHttp2Disable(true)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3})).withCurrentContext(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)).withImpersonateGroups(new String[]{"developer", "admin"})).withUserAgent("custom-user-agent")).build();
                ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config).hasFieldOrPropertyWithValue("autoConfigure", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://api-test.openshiftapps.com:6443/")).hasFieldOrPropertyWithValue("contexts", Collections.singletonList(ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext))).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)30)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)10)).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"EC")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)500)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)10)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("requestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("loggingInterval", (Object)1000)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)10000L)).hasFieldOrPropertyWithValue("uploadRequestTimeout", (Object)1000)).hasFieldOrPropertyWithValue("impersonateExtras", Collections.singletonMap("acme%2Fproject", Collections.singletonList("some-project")))).hasFieldOrPropertyWithValue("http2Disable", (Object)true)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object)e.getCurrentContext()).isEqualTo((Object)ConfigDisableAutoConfigurationTest.this.userConfiguredNamedContext)})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Object[])e.getImpersonateGroups()).containsExactly((Object[])new String[]{"developer", "admin"})})).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((String)e.getUserAgent()).isEqualTo("custom-user-agent")});
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubernetes.master");
                System.clearProperty("kubernetes.auth.serviceAccount.token");
                System.clearProperty("kubenamespace");
            }
        }
    }
}

