/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public abstract class StandardHttpClientBuilder<C extends HttpClient, F extends HttpClient.Factory, T extends StandardHttpClientBuilder<C, F, ?>>
implements HttpClient.Builder {
    protected LinkedHashMap<String, Interceptor> interceptors = new LinkedHashMap();
    protected Duration connectTimeout;
    protected Duration readTimeout;
    protected Duration writeTimeout;
    protected SSLContext sslContext;
    protected String proxyAuthorization;
    protected InetSocketAddress proxyAddress;
    protected boolean followRedirects;
    protected boolean preferHttp11;
    protected TlsVersion[] tlsVersions;
    protected boolean forStreaming;
    protected boolean authenticatorNone;
    protected Config requestConfig;
    protected C client;
    protected F clientFactory;
    protected TrustManager[] trustManagers;
    protected KeyManager[] keyManagers;

    protected StandardHttpClientBuilder(F clientFactory) {
        this.clientFactory = clientFactory;
    }

    public T readTimeout(long readTimeout, TimeUnit unit) {
        this.readTimeout = Duration.ofNanos(unit.toNanos(readTimeout));
        return (T)this;
    }

    public T writeTimeout(long writeTimeout, TimeUnit unit) {
        this.writeTimeout = Duration.ofNanos(unit.toNanos(writeTimeout));
        return (T)this;
    }

    public T connectTimeout(long connectTimeout, TimeUnit unit) {
        this.connectTimeout = Duration.ofNanos(unit.toNanos(connectTimeout));
        return (T)this;
    }

    public T forStreaming() {
        this.forStreaming = true;
        return (T)this;
    }

    public T addOrReplaceInterceptor(String name, Interceptor interceptor) {
        if (interceptor == null) {
            this.interceptors.remove(name);
        } else {
            this.interceptors.put(name, interceptor);
        }
        return (T)this;
    }

    public T authenticatorNone() {
        this.authenticatorNone = true;
        return (T)this;
    }

    public T sslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.sslContext = SSLUtils.sslContext(keyManagers, trustManagers);
        this.keyManagers = keyManagers;
        this.trustManagers = trustManagers;
        return (T)this;
    }

    public T followAllRedirects() {
        this.followRedirects = true;
        return (T)this;
    }

    public T proxyAddress(InetSocketAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
        return (T)this;
    }

    public T proxyAuthorization(String credentials) {
        this.proxyAuthorization = credentials;
        return (T)this;
    }

    public T tlsVersions(TlsVersion ... tlsVersions) {
        this.tlsVersions = tlsVersions;
        return (T)this;
    }

    public T requestConfig(Config requestConfig) {
        this.requestConfig = requestConfig;
        return (T)this;
    }

    public T preferHttp11() {
        this.preferHttp11 = true;
        return (T)this;
    }

    public T clientFactory(F clientFactory) {
        this.clientFactory = clientFactory;
        return (T)this;
    }

    protected abstract T newInstance(F var1);

    public T copy(C client) {
        T copy = this.newInstance(this.clientFactory);
        ((StandardHttpClientBuilder)copy).connectTimeout = this.connectTimeout;
        ((StandardHttpClientBuilder)copy).readTimeout = this.readTimeout;
        ((StandardHttpClientBuilder)copy).sslContext = this.sslContext;
        ((StandardHttpClientBuilder)copy).trustManagers = this.trustManagers;
        ((StandardHttpClientBuilder)copy).keyManagers = this.keyManagers;
        ((StandardHttpClientBuilder)copy).interceptors = new LinkedHashMap<String, Interceptor>(this.interceptors);
        ((StandardHttpClientBuilder)copy).proxyAddress = this.proxyAddress;
        ((StandardHttpClientBuilder)copy).proxyAuthorization = this.proxyAuthorization;
        ((StandardHttpClientBuilder)copy).tlsVersions = this.tlsVersions;
        ((StandardHttpClientBuilder)copy).preferHttp11 = this.preferHttp11;
        ((StandardHttpClientBuilder)copy).followRedirects = this.followRedirects;
        ((StandardHttpClientBuilder)copy).authenticatorNone = this.authenticatorNone;
        ((StandardHttpClientBuilder)copy).writeTimeout = this.writeTimeout;
        ((StandardHttpClientBuilder)copy).requestConfig = this.requestConfig;
        ((StandardHttpClientBuilder)copy).client = client;
        return copy;
    }

    public LinkedHashMap<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String getProxyAuthorization() {
        return this.proxyAuthorization;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isPreferHttp11() {
        return this.preferHttp11;
    }

    public TlsVersion[] getTlsVersions() {
        return this.tlsVersions;
    }

    public boolean isForStreaming() {
        return this.forStreaming;
    }

    public boolean isAuthenticatorNone() {
        return this.authenticatorNone;
    }

    public Config getRequestConfig() {
        return this.requestConfig;
    }

    public C getClient() {
        return this.client;
    }

    public F getClientFactory() {
        return this.clientFactory;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }
}

