/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.AuthProviderConfigBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class OpenIDConnectionUtilsTest {
    private TestStandardHttpClient httpClient;
    private TestStandardHttpClientBuilder singletonHttpClientBuilder;

    OpenIDConnectionUtilsTest() {
    }

    @BeforeEach
    void setUp() {
        TestStandardHttpClientFactory factory = new TestStandardHttpClientFactory(TestStandardHttpClientFactory.Mode.SINGLETON);
        this.httpClient = factory.newBuilder().build();
        this.singletonHttpClientBuilder = factory.newBuilder();
    }

    @Test
    void persistOAuthTokenWithUpdatedToken(@TempDir Path tempDir) throws IOException {
        OpenIDConnectionUtils.OAuthToken oAuthTokenResponse = new OpenIDConnectionUtils.OAuthToken();
        oAuthTokenResponse.setIdToken("id-token-updated");
        oAuthTokenResponse.setRefreshToken("refresh-token-updated");
        Path kubeConfig = Files.createTempFile(tempDir, "test", "kubeconfig", new FileAttribute[0]);
        Files.copy(OpenIDConnectionUtilsTest.class.getResourceAsStream("/test-kubeconfig-oidc"), kubeConfig, StandardCopyOption.REPLACE_EXISTING);
        Config originalConfig = Config.fromKubeconfig(null, (String)new String(Files.readAllBytes(kubeConfig), StandardCharsets.UTF_8), (String)kubeConfig.toFile().getAbsolutePath());
        OpenIDConnectionUtils.persistOAuthToken((Config)originalConfig, (OpenIDConnectionUtils.OAuthToken)oAuthTokenResponse, null);
        io.fabric8.kubernetes.api.model.Config config = KubeConfigUtils.parseConfig((File)kubeConfig.toFile());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
        NamedContext currentNamedContext = KubeConfigUtils.getCurrentContext((io.fabric8.kubernetes.api.model.Config)config);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)currentNamedContext);
        int currentUserIndex = KubeConfigUtils.getNamedUserIndexFromConfig((io.fabric8.kubernetes.api.model.Config)config, (String)currentNamedContext.getContext().getUser());
        org.junit.jupiter.api.Assertions.assertTrue((currentUserIndex > 0 ? 1 : 0) != 0);
        Map authProviderConfigInFile = ((NamedAuthInfo)config.getUsers().get(currentUserIndex)).getUser().getAuthProvider().getConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)authProviderConfigInFile.isEmpty());
        Map authProviderConfigInMemory = originalConfig.getAuthProvider().getConfig();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id-token-updated", authProviderConfigInMemory.get("id-token"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"refresh-token-updated", authProviderConfigInMemory.get("refresh-token"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id-token-updated", authProviderConfigInFile.get("id-token"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"refresh-token-updated", authProviderConfigInFile.get("refresh-token"));
    }

    @Test
    void resolveOIDCTokenFromAuthConfigShouldReturnOldTokenWhenRefreshNotSupported() throws Exception {
        HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
        currentAuthProviderConfig.put("client-id", "client-id");
        currentAuthProviderConfig.put("client-secret", "client-secret");
        currentAuthProviderConfig.put("id-token", "id-token");
        String token = (String)OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)Config.empty(), currentAuthProviderConfig, null).get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id-token", (Object)token);
    }

    @Test
    void resolveOIDCTokenFromAuthConfig_whenIDPCertNotPresentInAuthConfig_thenUseCertFromConfig() throws Exception {
        try (MockedStatic sslUtilsMockedStatic = Mockito.mockStatic(SSLUtils.class);){
            HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
            currentAuthProviderConfig.put("client-id", "client-id");
            currentAuthProviderConfig.put("client-secret", "client-secret");
            currentAuthProviderConfig.put("id-token", "id-token");
            currentAuthProviderConfig.put("refresh-token", "refresh-token");
            currentAuthProviderConfig.put("idp-issuer-url", "https://iam.cloud.example.com/identity");
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(Config.empty()).withCaCertData("cert")).withAuthProvider(new AuthProviderConfig())).build();
            this.httpClient.expect("/identity/.well-known/openid-configuration", 200, "{\"issuer\":\"https://iam.cloud.example.com/identity\",\"token_endpoint\":\"https://iam.cloud.example.com/identity/token\"}");
            this.httpClient.expect("/identity/token", 200, "{\"id_token\":\"thisisatesttoken\",\"access_token\":\"thisisrefreshtoken\",\"expires_in\":3599,\"scope\":\"openid https://www.exampleapis.com/auth/userinfo.email\",\"token_type\":\"Bearer\"}");
            OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)config, currentAuthProviderConfig, (HttpClient.Builder)this.singletonHttpClientBuilder).get();
            String decodedCert = new String(Base64.getDecoder().decode("cert"));
            sslUtilsMockedStatic.verify(() -> SSLUtils.trustManagers((String)((String)ArgumentMatchers.eq((Object)decodedCert)), (String)((String)ArgumentMatchers.isNull()), (boolean)ArgumentMatchers.anyBoolean(), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
            sslUtilsMockedStatic.verify(() -> SSLUtils.keyManagers((String)((String)ArgumentMatchers.eq((Object)decodedCert)), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
        }
    }

    @Test
    void resolveOIDCTokenFromAuthConfig_whenIDPCertNotPresentInAuthConfig_thenUseCertFileFromConfig(@TempDir File temporaryFolder) throws Exception {
        try (MockedStatic sslUtilsMockedStatic = Mockito.mockStatic(SSLUtils.class);){
            File caCertFile = new File(temporaryFolder, "ca.crt");
            Files.write(caCertFile.toPath(), "cert".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            HashMap<String, String> currentAuthProviderConfig = new HashMap<String, String>();
            currentAuthProviderConfig.put("client-id", "client-id");
            currentAuthProviderConfig.put("client-secret", "client-secret");
            currentAuthProviderConfig.put("id-token", "id-token");
            currentAuthProviderConfig.put("refresh-token", "refresh-token");
            currentAuthProviderConfig.put("idp-issuer-url", "https://iam.cloud.example.com/identity");
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(Config.empty()).withCaCertFile(caCertFile.getAbsolutePath())).withAuthProvider(new AuthProviderConfig())).build();
            this.httpClient.expect("/identity/.well-known/openid-configuration", 200, "{\"issuer\":\"https://iam.cloud.example.com/identity\",\"token_endpoint\":\"https://iam.cloud.example.com/identity/token\"}");
            this.httpClient.expect("/identity/token", 200, "{\"id_token\":\"thisisatesttoken\",\"access_token\":\"thisisrefreshtoken\",\"expires_in\":3599,\"scope\":\"openid https://www.exampleapis.com/auth/userinfo.email\",\"token_type\":\"Bearer\"}");
            OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig((Config)config, currentAuthProviderConfig, (HttpClient.Builder)this.singletonHttpClientBuilder).get();
            sslUtilsMockedStatic.verify(() -> SSLUtils.trustManagers((String)((String)ArgumentMatchers.eq((Object)"cert")), (String)((String)ArgumentMatchers.isNull()), (boolean)ArgumentMatchers.anyBoolean(), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
            sslUtilsMockedStatic.verify(() -> SSLUtils.keyManagers((String)((String)ArgumentMatchers.eq((Object)"cert")), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull()), (String)((String)ArgumentMatchers.isNull())));
        }
    }

    @Test
    void idTokenExpired_whenEmptyFormatProvided_thenReturnTrue() {
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken(""))).isTrue();
    }

    @Test
    void idTokenExpired_whenInvalidJwtTokenFormatProvided_thenReturnTrue() {
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken("invalid-jwt-token"))).isTrue();
    }

    @Test
    void idTokenExpired_whenInvalidJwtPayloadProvided_thenReturnTrue() {
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken("header.payload.signature"))).isTrue();
    }

    @Test
    void idTokenExpired_whenOldTokenProvided_thenReturnTrue() {
        String token = "eyJhbGciOiJSUzI1NiJ9.eyJpc3MiOiJodHRwczovL21sYi50cmVtb2xvLmxhbjo4MDQzL2F1dGgvaWRwL29pZGMiLCJhdWQiOiJrdWJlcm5ldGVzIiwiZXhwIjoxNDc0NTk2NjY5LCJqdGkiOiI2RDUzNXoxUEpFNjJOR3QxaWVyYm9RIiwiaWF0IjoxNDc0NTk2MzY5LCJuYmYiOjE0NzQ1OTYyNDksInN1YiI6Im13aW5kdSIsInVzZXJfcm9sZSI6WyJ1c2VycyIsIm5ldy1uYW1lc3BhY2Utdmlld2VyIl0sImVtYWlsIjoibXdpbmR1QG5vbW9yZWplZGkuY29tIn0.f2As579n9VNoaKzoF-dOQGmXkFKf1FMyNV0-va_B63jn-_n9LGSCca_6IVMP8pO-Zb4KvRqGyTP0r3HkHxYy5c81AnIh8ijarruczl-TK_yF5akjSTHFZD-0gRzlevBDiH8Q79NAr-ky0P4iIXS8lY9Vnjch5MF74Zx0c3alKJHJUnnpjIACByfF2SCaYzbWFMUNat-K1PaUk5-ujMBG7yYnr95xD-63n8CO8teGUAAEMx6zRjzfhnhbzX-ajwZLGwGUBT4WqjMs70-6a7_8gZmLZb2az1cZynkFRj2BaCkVT3A2RrjeEwZEtGXlMqKJ1_I2ulrOVsYx01_yD35-rw";
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken(token))).isTrue();
    }

    @Test
    void idTokenExpired_whenTokenStillNotExpired_thenReturnFalse() {
        Instant tokenExp = Instant.now().plusSeconds(30L);
        String payload = "{\"exp\": " + tokenExp.getEpochSecond() + "}";
        String token = "header." + Base64.getEncoder().encodeToString(payload.getBytes()) + ".signature";
        Assertions.assertThat((boolean)OpenIDConnectionUtils.idTokenExpired((Config)this.createNewConfigWithAuthProviderIdToken(token))).isFalse();
    }

    private Config createNewConfigWithAuthProviderIdToken(String idToken) {
        return ((ConfigBuilder)new ConfigBuilder(Config.empty()).withAuthProvider(((AuthProviderConfigBuilder)new AuthProviderConfigBuilder().addToConfig("id-token", idToken)).build())).build();
    }
}

