/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class KubernetesClientExceptionTest {
    KubernetesClientExceptionTest() {
    }

    @DisplayName(value="Exception from HttpRequest contains resource metadata")
    @ParameterizedTest(name="{index} ''{0}'': group: ''{1}'', version: ''{2}'', plural: ''{3}'', namespace: ''{4}'', name: ''{5}''")
    @MethodSource(value={"exceptionFromHttpRequestContainsExpectedMetadataInput"})
    void exceptionFromHttpRequestContainsExpectedMetadata(String url, String expectedGroup, String expectedVersion, String expectedPlural, String expectedNamespace, String expectedName) {
        KubernetesClientException result = new KubernetesClientException(null, null, -1, null, new StandardHttpRequest.Builder().uri(url).build());
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThat((Throwable)result).hasFieldOrPropertyWithValue("group", (Object)expectedGroup)).hasFieldOrPropertyWithValue("version", (Object)expectedVersion)).hasFieldOrPropertyWithValue("resourcePlural", (Object)expectedPlural)).hasFieldOrPropertyWithValue("namespace", (Object)expectedNamespace)).hasFieldOrPropertyWithValue("name", (Object)expectedName);
    }

    static Stream<Arguments> exceptionFromHttpRequestContainsExpectedMetadataInput() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"https://localhost:8080/apis/apps/v1/deployments", "apps", "v1", "deployments", null, null}), Arguments.arguments((Object[])new Object[]{"https://localhost:8080/api/v1/pods", "", "v1", "pods", null, null}), Arguments.arguments((Object[])new Object[]{"https://localhost:8080/apis/apps/v1/namespaces/foo/deployments", "apps", "v1", "deployments", "foo", null}), Arguments.arguments((Object[])new Object[]{"https://localhost:8080/api/v1/namespaces/kube-system/pods/coredns-78fcd69978-7ls8f", "", "v1", "pods", "kube-system", "coredns-78fcd69978-7ls8f"}), Arguments.arguments((Object[])new Object[]{"https://localhost:8080/apis/apps/v1/namespaces/foo/deployments/bar-78fcd69978-7ls8f", "apps", "v1", "deployments", "foo", "bar-78fcd69978-7ls8f"}));
    }
}

