/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Version;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.net.URL;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class ConfigConstructorTest {
    ConfigConstructorTest() {
    }

    @Test
    @DisplayName(value="empty configuration, no default values, no auto configured values")
    void emptyConfiguration() {
        Config config = new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).isNotNull()).satisfies(new ThrowingConsumer[]{c -> AssertionsForClassTypes.assertThat((Boolean)c.getTrustCerts()).isNull()})).satisfies(new ThrowingConsumer[]{c -> AssertionsForClassTypes.assertThat((Boolean)c.getDisableHostnameVerification()).isNull()})).hasFieldOrPropertyWithValue("masterUrl", null)).hasFieldOrPropertyWithValue("namespace", null)).hasFieldOrPropertyWithValue("username", null)).hasFieldOrPropertyWithValue("password", null)).hasFieldOrPropertyWithValue("caCertFile", null)).hasFieldOrPropertyWithValue("caCertData", null)).hasFieldOrPropertyWithValue("clientCertFile", null)).hasFieldOrPropertyWithValue("clientCertData", null)).hasFieldOrPropertyWithValue("clientKeyFile", null)).hasFieldOrPropertyWithValue("clientKeyData", null)).hasFieldOrPropertyWithValue("clientKeyAlgo", null)).hasFieldOrPropertyWithValue("clientKeyPassphrase", null)).hasFieldOrPropertyWithValue("httpProxy", null)).hasFieldOrPropertyWithValue("watchReconnectInterval", null)).hasFieldOrPropertyWithValue("watchReconnectLimit", null)).hasFieldOrPropertyWithValue("loggingInterval", null)).hasFieldOrPropertyWithValue("requestTimeout", null)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", null)).hasFieldOrPropertyWithValue("tlsVersions", null)).hasFieldOrPropertyWithValue("trustStoreFile", null)).hasFieldOrPropertyWithValue("trustStorePassphrase", null)).hasFieldOrPropertyWithValue("keyStoreFile", null)).hasFieldOrPropertyWithValue("keyStorePassphrase", null)).hasFieldOrPropertyWithValue("maxConcurrentRequests", null)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", null)).hasFieldOrPropertyWithValue("websocketPingInterval", null)).hasFieldOrPropertyWithValue("connectionTimeout", null)).hasFieldOrPropertyWithValue("scaleTimeout", null)).hasFieldOrPropertyWithValue("watchReconnectInterval", null)).hasFieldOrPropertyWithValue("http2Disable", null)).hasFieldOrPropertyWithValue("httpsProxy", null)).hasFieldOrPropertyWithValue("proxyUsername", null)).hasFieldOrPropertyWithValue("proxyPassword", null)).hasFieldOrPropertyWithValue("noProxy", null)).hasFieldOrPropertyWithValue("autoOAuthToken", null);
    }

    @Nested
    @DisplayName(value="Config auto configured values initialization (autoConfigure=true)")
    class AutoConfiguredValues {
        AutoConfiguredValues() {
        }

        @Nested
        @DisplayName(value="(defaultValues=false)")
        class DefaultValuesFalse {
            DefaultValuesFalse() {
            }

            @Test
            @DisplayName(value="should throw exception")
            void throwsException() {
                try {
                    String kubeConfigFilePath = Utils.filePath((URL)ConfigConstructorTest.class.getResource("/test-kubeconfig"));
                    System.setProperty("kubeconfig", kubeConfigFilePath);
                    AssertionsForClassTypes.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(false)));
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }

        @Nested
        @DisplayName(value="(defaultValues=true)")
        class DefaultValuesTrue {
            DefaultValuesTrue() {
            }

            @Test
            @DisplayName(value="from system properties")
            void configLoadedViaSystemProperties() {
                try {
                    System.setProperty("kubernetes.master", "http://autoconfigured-master:80");
                    System.setProperty("kubernetes.namespace", "autoconfigured-namespace");
                    System.setProperty("kubernetes.auth.token", "autoconfigured-token");
                    System.setProperty("kubernetes.auth.basic.username", "autoconfigured-user");
                    System.setProperty("kubernetes.auth.basic.password", "autoconfigured-pass");
                    System.setProperty("kubernetes.trust.certificates", "true");
                    System.setProperty("kubernetes.disable.hostname.verification", "true");
                    System.setProperty("kubernetes.certs.ca.file", "/autoconfigured-path/to/cert");
                    System.setProperty("kubernetes.certs.ca.data", "autoconfigured-cacertdata");
                    System.setProperty("kubernetes.certs.client.file", "/autoconfigured-path/to/clientcert");
                    System.setProperty("kubernetes.certs.client.data", "autoconfigured-clientcertdata");
                    System.setProperty("kubernetes.certs.client.key.file", "/autoconfigured-path/to/clientkey");
                    System.setProperty("kubernetes.certs.client.key.data", "autoconfigured-clientkeydata");
                    System.setProperty("kubernetes.certs.client.key.algo", "autoconfigured-algo");
                    System.setProperty("kubernetes.certs.client.key.passphrase", "autoconfigured-passphrase");
                    System.setProperty("kubernetes.certs.client.key.file", "/autoconfigured-path/to/clientkey");
                    System.setProperty("kubernetes.max.concurrent.requests", "120");
                    System.setProperty("kubernetes.max.concurrent.requests.per.host", "20");
                    System.setProperty("kubernetes.watch.reconnectInterval", "5000");
                    System.setProperty("kubernetes.watch.reconnectLimit", "5");
                    System.setProperty("kubernetes.request.timeout", "5000");
                    System.setProperty("http.proxy", "autoconfigured-httpProxy");
                    System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
                    System.setProperty("kubernetes.truststore.file", "/autoconfigured-path/to/truststore");
                    System.setProperty("kubernetes.truststore.passphrase", "autoconfigured-truststorePassphrase");
                    System.setProperty("kubernetes.keystore.file", "/autoconfigured-path/to/keystore");
                    System.setProperty("kubernetes.keystore.passphrase", "autoconfigured-keystorePassphrase");
                    System.setProperty("kubernetes.upload.request.timeout", "600000");
                    System.setProperty("kubernetes.websocket.ping.interval", "1000");
                    System.setProperty("kubernetes.connection.timeout", "1000");
                    System.setProperty("kubernetes.scale.timeout", "1000");
                    System.setProperty("https.proxy", "autoconfigured-httpsProxy");
                    System.setProperty("no.proxy", "autoconfigured-no-proxy-url1.io,autoconfigured-no-proxy-url2.io");
                    System.setProperty("proxy.username", "autoconfigured-proxyUsername");
                    System.setProperty("proxy.password", "autoconfigured-proxyPassword");
                    Config config = new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
                    ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("apiVersion", (Object)"v1")).hasFieldOrPropertyWithValue("onlyHttpWatches", (Object)false)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("userAgent", (Object)("fabric8-kubernetes-client/" + Version.clientVersion()))).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://autoconfigured-master:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"autoconfigured-namespace")).hasFieldOrPropertyWithValue("username", (Object)"autoconfigured-user")).hasFieldOrPropertyWithValue("password", (Object)"autoconfigured-pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/autoconfigured-path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"autoconfigured-cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/autoconfigured-path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"autoconfigured-clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/autoconfigured-path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"autoconfigured-clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"autoconfigured-algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"autoconfigured-passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"autoconfigured-httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/autoconfigured-path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"autoconfigured-truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/autoconfigured-path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"autoconfigured-keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"autoconfigured-httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"autoconfigured-proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"autoconfigured-proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"autoconfigured-no-proxy-url1.io", "autoconfigured-no-proxy-url2.io"})).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"autoconfigured-token");
                }
                finally {
                    System.clearProperty("kubernetes.master");
                    System.clearProperty("kubernetes.namespace");
                    System.clearProperty("kubernetes.auth.token");
                    System.clearProperty("kubernetes.auth.basic.username");
                    System.clearProperty("kubernetes.auth.basic.password");
                    System.clearProperty("kubernetes.trust.certificates");
                    System.clearProperty("kubernetes.disable.hostname.verification");
                    System.clearProperty("kubernetes.certs.ca.file");
                    System.clearProperty("kubernetes.certs.ca.data");
                    System.clearProperty("kubernetes.certs.client.file");
                    System.clearProperty("kubernetes.certs.client.data");
                    System.clearProperty("kubernetes.certs.client.key.file");
                    System.clearProperty("kubernetes.certs.client.key.data");
                    System.clearProperty("kubernetes.certs.client.key.algo");
                    System.clearProperty("kubernetes.certs.client.key.passphrase");
                    System.clearProperty("kubernetes.certs.client.key.file");
                    System.clearProperty("kubernetes.max.concurrent.requests");
                    System.clearProperty("kubernetes.max.concurrent.requests.per.host");
                    System.clearProperty("kubernetes.watch.reconnectInterval");
                    System.clearProperty("kubernetes.watch.reconnectLimit");
                    System.clearProperty("kubernetes.request.timeout");
                    System.clearProperty("http.proxy");
                    System.clearProperty("kubernetes.tls.versions");
                    System.clearProperty("kubernetes.truststore.file");
                    System.clearProperty("kubernetes.truststore.passphrase");
                    System.clearProperty("kubernetes.keystore.file");
                    System.clearProperty("kubernetes.keystore.passphrase");
                    System.clearProperty("kubernetes.upload.request.timeout");
                    System.clearProperty("kubernetes.websocket.ping.interval");
                    System.clearProperty("kubernetes.connection.timeout");
                    System.clearProperty("kubernetes.scale.timeout");
                    System.clearProperty("https.proxy");
                    System.clearProperty("no.proxy");
                    System.clearProperty("proxy.username");
                    System.clearProperty("proxy.password");
                }
            }

            @Test
            @DisplayName(value="from kube config")
            void configLoadedViaKubeConfig() {
                try {
                    String kubeConfigFilePath = Utils.filePath((URL)ConfigConstructorTest.class.getResource("/test-kubeconfig"));
                    System.setProperty("kubeconfig", kubeConfigFilePath);
                    Config config = new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
                    ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://172.28.128.4:8443/")).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("namespace", (Object)"testns")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"token")).satisfies(new ThrowingConsumer[]{c -> {
                        AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)c.getCaCertFile()).endsWith((CharSequence)"testns/ca.pem".replace("/", File.separator));
                    }})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((File)new File(c.getCaCertFile())).isAbsolute()})).hasFieldOrPropertyWithValue("file", (Object)new File(kubeConfigFilePath));
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }

            @Test
            @DisplayName(value="from Service Account")
            void configLoadedViaServiceAccount() {
                try {
                    System.setProperty("kubeconfig", "/dev/null");
                    System.setProperty("kubernetes.auth.serviceAccount.token", Utils.filePath((URL)ConfigConstructorTest.class.getResource("/config-source-precedence/serviceaccount/token")));
                    System.setProperty("kubenamespace", Utils.filePath((URL)ConfigConstructorTest.class.getResource("/config-source-precedence/serviceaccount/namespace")));
                    Config config = new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
                    ((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("namespace", (Object)"namespace-from-mounted-serviceaccount")).extracting(Config::getAutoOAuthToken).asString().contains(new CharSequence[]{"token-from-mounted-serviceaccount"});
                }
                finally {
                    System.clearProperty("kubeconfig");
                    System.clearProperty("kubernetes.auth.serviceAccount.token");
                    System.clearProperty("kubenamespace");
                }
            }
        }
    }

    @Nested
    @DisplayName(value="Config default values initialization with system properties for auto configuration")
    class DefaultValues {
        DefaultValues() {
        }

        @BeforeEach
        void setUp() {
            System.setProperty("kubernetes.master", "http://autoconfigured-master:80");
            System.setProperty("kubernetes.namespace", "autoconfigured-namespace");
            System.setProperty("kubernetes.auth.token", "autoconfigured-token");
            System.setProperty("kubernetes.auth.basic.username", "autoconfigured-user");
            System.setProperty("kubernetes.auth.basic.password", "autoconfigured-pass");
            System.setProperty("kubernetes.trust.certificates", "true");
            System.setProperty("kubernetes.disable.hostname.verification", "true");
            System.setProperty("kubernetes.certs.ca.file", "/autoconfigured-path/to/cert");
            System.setProperty("kubernetes.certs.ca.data", "autoconfigured-cacertdata");
            System.setProperty("kubernetes.certs.client.file", "/autoconfigured-path/to/clientcert");
            System.setProperty("kubernetes.certs.client.data", "autoconfigured-clientcertdata");
            System.setProperty("kubernetes.certs.client.key.file", "/autoconfigured-path/to/clientkey");
            System.setProperty("kubernetes.certs.client.key.data", "autoconfigured-clientkeydata");
            System.setProperty("kubernetes.certs.client.key.algo", "autoconfigured-algo");
            System.setProperty("kubernetes.certs.client.key.passphrase", "autoconfigured-passphrase");
            System.setProperty("kubernetes.certs.client.key.file", "/autoconfigured-path/to/clientkey");
            System.setProperty("kubernetes.max.concurrent.requests", "120");
            System.setProperty("kubernetes.max.concurrent.requests.per.host", "20");
            System.setProperty("kubernetes.watch.reconnectInterval", "5000");
            System.setProperty("kubernetes.watch.reconnectLimit", "5");
            System.setProperty("kubernetes.request.timeout", "5000");
            System.setProperty("http.proxy", "autoconfigured-httpProxy");
            System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
            System.setProperty("kubernetes.truststore.file", "/autoconfigured-path/to/truststore");
            System.setProperty("kubernetes.truststore.passphrase", "autoconfigured-truststorePassphrase");
            System.setProperty("kubernetes.keystore.file", "/autoconfigured-path/to/keystore");
            System.setProperty("kubernetes.keystore.passphrase", "autoconfigured-keystorePassphrase");
            System.setProperty("kubernetes.upload.request.timeout", "600000");
            System.setProperty("kubernetes.websocket.ping.interval", "1000");
            System.setProperty("kubernetes.connection.timeout", "1000");
            System.setProperty("kubernetes.scale.timeout", "1000");
            System.setProperty("https.proxy", "autoconfigured-httpsProxy");
            System.setProperty("no.proxy", "autoconfigured-no-proxy-url1.io,autoconfigured-no-proxy-url2.io");
            System.setProperty("proxy.username", "autoconfigured-proxyUsername");
            System.setProperty("proxy.password", "autoconfigured-proxyPassword");
        }

        @AfterEach
        void tearDown() {
            System.clearProperty("kubernetes.master");
            System.clearProperty("kubernetes.namespace");
            System.clearProperty("kubernetes.auth.token");
            System.clearProperty("kubernetes.auth.basic.username");
            System.clearProperty("kubernetes.auth.basic.password");
            System.clearProperty("kubernetes.trust.certificates");
            System.clearProperty("kubernetes.disable.hostname.verification");
            System.clearProperty("kubernetes.certs.ca.file");
            System.clearProperty("kubernetes.certs.ca.data");
            System.clearProperty("kubernetes.certs.client.file");
            System.clearProperty("kubernetes.certs.client.data");
            System.clearProperty("kubernetes.certs.client.key.file");
            System.clearProperty("kubernetes.certs.client.key.data");
            System.clearProperty("kubernetes.certs.client.key.algo");
            System.clearProperty("kubernetes.certs.client.key.passphrase");
            System.clearProperty("kubernetes.certs.client.key.file");
            System.clearProperty("kubernetes.max.concurrent.requests");
            System.clearProperty("kubernetes.max.concurrent.requests.per.host");
            System.clearProperty("kubernetes.watch.reconnectInterval");
            System.clearProperty("kubernetes.watch.reconnectLimit");
            System.clearProperty("kubernetes.request.timeout");
            System.clearProperty("http.proxy");
            System.clearProperty("kubernetes.tls.versions");
            System.clearProperty("kubernetes.truststore.file");
            System.clearProperty("kubernetes.truststore.passphrase");
            System.clearProperty("kubernetes.keystore.file");
            System.clearProperty("kubernetes.keystore.passphrase");
            System.clearProperty("kubernetes.upload.request.timeout");
            System.clearProperty("kubernetes.websocket.ping.interval");
            System.clearProperty("kubernetes.connection.timeout");
            System.clearProperty("kubernetes.scale.timeout");
            System.clearProperty("https.proxy");
            System.clearProperty("no.proxy");
            System.clearProperty("proxy.username");
            System.clearProperty("proxy.password");
        }

        @Test
        @DisplayName(value="when autoConfigure enabled, then auto configured values override default values")
        void whenAutoConfigureEnabled_thenUseBothDefaultAndAutoConfiguredValues() {
            Config config = new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("apiVersion", (Object)"v1")).hasFieldOrPropertyWithValue("onlyHttpWatches", (Object)false)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("userAgent", (Object)("fabric8-kubernetes-client/" + Version.clientVersion()))).hasFieldOrPropertyWithValue("trustCerts", (Object)true)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)true)).hasFieldOrPropertyWithValue("masterUrl", (Object)"http://autoconfigured-master:80/")).hasFieldOrPropertyWithValue("namespace", (Object)"autoconfigured-namespace")).hasFieldOrPropertyWithValue("username", (Object)"autoconfigured-user")).hasFieldOrPropertyWithValue("password", (Object)"autoconfigured-pass")).hasFieldOrPropertyWithValue("caCertFile", (Object)"/autoconfigured-path/to/cert")).hasFieldOrPropertyWithValue("caCertData", (Object)"autoconfigured-cacertdata")).hasFieldOrPropertyWithValue("clientCertFile", (Object)"/autoconfigured-path/to/clientcert")).hasFieldOrPropertyWithValue("clientCertData", (Object)"autoconfigured-clientcertdata")).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/autoconfigured-path/to/clientkey")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"autoconfigured-clientkeydata")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"autoconfigured-algo")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"autoconfigured-passphrase")).hasFieldOrPropertyWithValue("httpProxy", (Object)"autoconfigured-httpProxy")).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)5)).hasFieldOrPropertyWithValue("requestTimeout", (Object)5000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)600000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).hasFieldOrPropertyWithValue("trustStoreFile", (Object)"/autoconfigured-path/to/truststore")).hasFieldOrPropertyWithValue("trustStorePassphrase", (Object)"autoconfigured-truststorePassphrase")).hasFieldOrPropertyWithValue("keyStoreFile", (Object)"/autoconfigured-path/to/keystore")).hasFieldOrPropertyWithValue("keyStorePassphrase", (Object)"autoconfigured-keystorePassphrase")).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)120)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)20)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)1000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)1000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)1000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)5000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", (Object)"autoconfigured-httpsProxy")).hasFieldOrPropertyWithValue("proxyUsername", (Object)"autoconfigured-proxyUsername")).hasFieldOrPropertyWithValue("proxyPassword", (Object)"autoconfigured-proxyPassword")).hasFieldOrPropertyWithValue("noProxy", (Object)new String[]{"autoconfigured-no-proxy-url1.io", "autoconfigured-no-proxy-url2.io"})).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"autoconfigured-token");
        }

        @Test
        @DisplayName(value="when autoConfigure disabled, then auto configured values are ignored")
        void whenAutoConfigureDisabled_thenOnlyUseDefaultValues() {
            Config config = new Config(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(true));
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)AssertionsForClassTypes.assertThat((Object)config).isNotNull()).hasFieldOrPropertyWithValue("apiVersion", (Object)"v1")).hasFieldOrPropertyWithValue("onlyHttpWatches", (Object)false)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("userAgent", (Object)("fabric8-kubernetes-client/" + Version.clientVersion()))).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://kubernetes.default.svc/")).hasFieldOrPropertyWithValue("namespace", null)).hasFieldOrPropertyWithValue("username", null)).hasFieldOrPropertyWithValue("password", null)).hasFieldOrPropertyWithValue("caCertFile", null)).hasFieldOrPropertyWithValue("caCertData", null)).hasFieldOrPropertyWithValue("clientCertFile", null)).hasFieldOrPropertyWithValue("clientCertData", null)).hasFieldOrPropertyWithValue("clientKeyFile", null)).hasFieldOrPropertyWithValue("clientKeyData", null)).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("clientKeyPassphrase", (Object)"changeit")).hasFieldOrPropertyWithValue("httpProxy", null)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("watchReconnectLimit", (Object)-1)).hasFieldOrPropertyWithValue("requestTimeout", (Object)10000)).hasFieldOrPropertyWithValue("requestConfig.uploadRequestTimeout", (Object)120000)).hasFieldOrPropertyWithValue("tlsVersions", (Object)new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2})).hasFieldOrPropertyWithValue("trustStoreFile", null)).hasFieldOrPropertyWithValue("trustStorePassphrase", null)).hasFieldOrPropertyWithValue("keyStoreFile", null)).hasFieldOrPropertyWithValue("keyStorePassphrase", null)).hasFieldOrPropertyWithValue("maxConcurrentRequests", (Object)64)).hasFieldOrPropertyWithValue("maxConcurrentRequestsPerHost", (Object)5)).hasFieldOrPropertyWithValue("websocketPingInterval", (Object)30000L)).hasFieldOrPropertyWithValue("connectionTimeout", (Object)10000)).hasFieldOrPropertyWithValue("scaleTimeout", (Object)600000L)).hasFieldOrPropertyWithValue("watchReconnectInterval", (Object)1000)).hasFieldOrPropertyWithValue("http2Disable", (Object)false)).hasFieldOrPropertyWithValue("httpsProxy", null)).hasFieldOrPropertyWithValue("proxyUsername", null)).hasFieldOrPropertyWithValue("proxyPassword", null)).hasFieldOrPropertyWithValue("noProxy", null)).hasFieldOrPropertyWithValue("autoOAuthToken", null);
        }
    }
}

