/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMetaAssert;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.NetNamespace;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractNetNamespaceAssert<S extends AbstractNetNamespaceAssert<S, A>, A extends NetNamespace>
extends AbstractAssert<S, A> {
    protected AbstractNetNamespaceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((NetNamespace)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((NetNamespace)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> egressIPs() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((NetNamespace)this.actual).getEgressIPs(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "egressIPs"), new Object[0]);
        return answer;
    }

    public StringAssert kind() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((NetNamespace)this.actual).getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"), new Object[0]);
    }

    public ObjectMetaAssert metadata() {
        this.isNotNull();
        return (ObjectMetaAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((NetNamespace)this.actual).getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"), new Object[0]));
    }

    public S hasNetid(Integer netid) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting netid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualNetid = ((NetNamespace)this.actual).getNetid();
        if (!Objects.areEqual((Object)actualNetid, (Object)netid)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, netid, actualNetid});
        }
        return (S)((Object)((AbstractNetNamespaceAssert)this.myself));
    }

    public StringAssert netname() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((NetNamespace)this.actual).getNetname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "netname"), new Object[0]);
    }
}

